﻿-- Author      : Nogarder
-- Create Date : 2010/7/3 20:39:58

local NPA_CastWarning={}
--config
local NPA_CastWarning_DefaultSettings={
		["CastWarning_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=7,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",

			},
		["CastWarning_IconData"]={
			OffsetX=-75,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CastWarning_BorderData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=125,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Tooltips\\UI-StatusBar-Border",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CastWarning_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=10,
			Width=120,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\NPA\\texture\\mono\\bar",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CastWarning_IconBackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\blank",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CastWarning_IconOverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["CastWarning_IconShieldData"]={
			OffsetX=0,
			OffsetY=0,
			Height=43,
			Width=43,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\iconshield",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CastWarning_BarShieldData"]={
			OffsetX=0,
			OffsetY=0,
			Height=30,
			Width=125,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\barshield",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,	
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["CastWarning_TextData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=0,
			OffsetY=-10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,	
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},

		["CastWarning_ValueData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=-60,
			OffsetY=-10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="LEFT",
			ToAnchor="CENTER",
			},

		["CastWarning_MaxData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=60,
			OffsetY=-10,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="RIGHT",
			ToAnchor="CENTER",
			},

		["CastWarning_OffsetX"]=0,
		["CastWarning_OffsetY"]=-20,

		["CastWarning_ShowName"]=1,
		["CastWarning_OnlyPlayer"]=0,

		["CastWarning_ShowText"]=0,
		["CastWarning_ShowMax"]=0,

		["CastWarning_Shield"]=1,

		["CastWarning_HideTotem"]=1,

		["CastWarning_AlwaysShowShield"]=0,

		["CastWarning_ColorBySchool"]=1,

		["CastWarning_ReversTime"]=0,
	}

local NPA_CastWarning_Config=NPA_CastWarning_DefaultSettings

function NPA_CastWarning:ResetConfig()
	NPA_Config["CastWarning"]=CopyTable(NPA_CastWarning_DefaultSettings)
end

local GetTime=GetTime
local pairs=pairs
local table_insert=table.insert
local NPA_CastWarning_Frame={}
local unpack=unpack
local floor=floor

local NPA_CastWarning_SpellTypeColor={
	[1]={r=1,g=1,b=0},
	[2]={r=1,g=1,b=0.5},
	[4]={r=1,g=0.3,b=0},
	[8]={r=0.25,g=1,b=0.25},
	[16]={r=0.5,g=1,b=1},
	[32]={r=0.5,g=0.5,b=1},
	[64]={r=1,g=0.5,b=1}
}
local ManageBar=NPA_Core.ManageBar

local function NPA_CastWarning_OnUpdate(nTime,self,guid,unitdata,_,guids,frame,hostile,isplayer,default,recentUpdated)
	if(not unitdata)then
		self:Hide()
		return
	end
	local icon=self.Icon
	local defaultshield

	if(default)then
		defaultshield=frame.Parent.Default.CastBarShield
	end

	local castinfo=unitdata.CastInfo
	local totem=frame["ClassIcon"]
	if(castinfo and (isplayer==1 or NPA_CastWarning_Config["CastWarning_OnlyPlayer"]~=1 or guid==guids.Focus or guid==guids.Pet or guid==guids.Target or guid==guids.Mouseover) and
		(not (totem and totem.IsTotem==1 and NPA_CastWarning_Config["CastWarning_HideTotem"]==1)))then
		if(nTime < castinfo.EndTime)then
			local value
			local bar=self.Bar
			local length=castinfo.EndTime-castinfo.StartTime
			if(length==0)then
				self:Hide()
				return
			end

			if(castinfo.Channel)then
				value=castinfo.StartTime+castinfo.EndTime-nTime
			else
				value=nTime
			end
			local start
			if(NPA_CastWarning_Config["CastWarning_ReversTime"]==1)then
				start=castinfo.EndTime-value
			else
				start=value-castinfo.StartTime
			end

			local percent=start/length
			bar.Percent=percent
			ManageBar(nil,bar)
			
			
			icon:SetTexture(castinfo.Icon)

			--using default
			if(castinfo.NotInterrupt or NPA_CastWarning_Config["CastWarning_AlwaysShowShield"]==1)then
				self.Shield:Show()
				self.BarShield:Show()
			else
				self.Shield:Hide()
				self.BarShield:Hide()
			end
			
			local color
			if(NPA_CastWarning_Config["CastWarning_ColorBySchool"]==1)then
				local school=unitdata.SpellSchool
				if(school)then
					color=NPA_CastWarning_SpellTypeColor[school] or {r=1,b=1,g=1}
				else
					color={r=1,b=1,g=1}
				end
			else
				color={r=1,b=1,g=1}
			end
			bar:SetVertexColor(color.r*bar.R,color.g*bar.G,color.b*bar.B)
			
			if(castinfo.Name and NPA_CastWarning_Config["CastWarning_ShowName"]==1)then
				local text=self.Text
				text:SetTextColor(color.r*text.R,color.g*text.G,color.b*text.B)
				text:SetText(castinfo.Name)
			end

			
			if(NPA_CastWarning_Config["CastWarning_ShowText"]==1)then
				local value=self.Value
				value:SetText(floor((start)*10)/10)
				value:SetTextColor(color.r*value.R,color.g*value.G,color.b*value.B)
			end
			
			if(NPA_CastWarning_Config["CastWarning_ShowMax"]==1)then
				local max=self.Max
				max:SetText(floor((length)*10)/10)
				max:SetTextColor(color.r*max.R,color.g*max.G,color.b*max.B)
			end
			self:Show()
		else
			self:Hide()
		end
	else
		self:Hide()
	end	
end


local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_CastWarning_SetFrame(castbar)
	castbar:SetPoint("CENTER",castbar:GetParent(),"CENTER",NPA_CastWarning_Config["CastWarning_OffsetX"],NPA_CastWarning_Config["CastWarning_OffsetY"])


	ManageTexture(nil,castbar.Icon,NPA_CastWarning_Config["CastWarning_IconData"],castbar)
	ManageTexture(nil,castbar.IconBackground,NPA_CastWarning_Config["CastWarning_IconBackgroundData"],castbar.Icon)
	ManageTexture(nil,castbar.Shield,NPA_CastWarning_Config["CastWarning_IconShieldData"],castbar.Icon)
	ManageTexture(nil,castbar.IconOverlay,NPA_CastWarning_Config["CastWarning_IconOverlayData"],castbar.Icon)

	ManageTexture(nil,castbar.Bar,NPA_CastWarning_Config["CastWarning_BarData"],castbar,1)
	ManageTexture(nil,castbar.BarShield,NPA_CastWarning_Config["CastWarning_BarShieldData"],castbar)
	ManageTexture(nil,castbar.Background,NPA_CastWarning_Config["CastWarning_BackgroundData"],castbar)
	ManageTexture(nil,castbar.Border,NPA_CastWarning_Config["CastWarning_BorderData"],castbar)

	ManageFont(nil,castbar.Text,NPA_CastWarning_Config["CastWarning_TextData"],castbar)
	ManageFont(nil,castbar.Value,NPA_CastWarning_Config["CastWarning_ValueData"],castbar)
	ManageFont(nil,castbar.Max,NPA_CastWarning_Config["CastWarning_MaxData"],castbar)


	if(NPA_CastWarning_Config["CastWarning_ShowName"]==1)then
		castbar.Text:Show()
	else
		castbar.Text:Hide()
	end

			
	if(NPA_CastWarning_Config["CastWarning_ShowText"]==1)then
		castbar.Value:Show()
	else
		castbar.Value:Hide()
	end
			
	if(NPA_CastWarning_Config["CastWarning_ShowMax"]==1)then
		castbar.Max:Show()
	else
		castbar.Max:Hide()
	end
end


local function NPA_CastWarning_HookFrame(frame)
	local castbar=CreateFrame("Frame","NPA_CastBar_MainFrame",frame)
	castbar:SetHeight(1)
	castbar:SetWidth(1)
	castbar:SetFrameStrata("LOW")
	castbar:Hide()

	local bar=castbar:CreateTexture("NPA_CastBar_Bar","BORDER",nil)
	bar:Show()

	local barborder=castbar:CreateTexture("NPA_CastBar_Border","ARTWORK",nil)
	barborder:Show()

	local background=castbar:CreateTexture("NPA_CastBar_Background","BACKGROUND",nil)
	background:Show()

	local barshield=castbar:CreateTexture("NPA_CastBar_BarShield","OVERLAY",nil)
	barshield:Hide()

	local text=castbar:CreateFontString("NPA_CastBar_Text","OVERLAY",nil)

	local value=castbar:CreateFontString("NPA_CastBar_Value","OVERLAY",nil)

	local max=castbar:CreateFontString("NPA_CastBar_Max","OVERLAY",nil)
	


	local iconlayer=CreateFrame("Frame","NPA_CastBar_IconFrame",castbar)
	iconlayer:SetHeight(1)
	iconlayer:SetWidth(1)
	iconlayer:Show()
	iconlayer:SetPoint("CENTER",castbar,"CENTER")

	local icon=iconlayer:CreateTexture("NPA_CastBar_Icon","BORDER",nil)
	icon:Show()

	local iconbackground=iconlayer:CreateTexture("NPA_CastBar_IconBackground","BACKGROUND",nil)
	iconbackground:Show()

	local iconoverlay=iconlayer:CreateTexture("NPA_CastBar_IconOverlay","ARTWORK",nil)

	local shield=iconlayer:CreateTexture("NPA_CastBar_Shield","OVERLAY",nil)
	shield:Hide()

	local parent=frame.Parent
	local default=parent.Default

	if(default)then
		default.CastBarOverlay:SetTexCoord(0,0,0,0)
		default.CastBarShield:SetTexCoord(0,0,0,0)
		default.SpellIcon:SetWidth(000.1)
		default.CastBar:SetStatusBarTexture(nil)
		default.CastBar:SetStatusBarTexture(nil)	
		default.CastBarOverlay:SetTexture(nil)
		default.CastBarShield:SetTexture(nil)
	end
	
	castbar.IconBackground=iconbackground
	castbar.Background=background
	castbar.Bar=bar
	castbar.Icon=icon
	castbar.Shield=shield
	castbar.Text=text
	castbar.Border=barborder
	castbar.Value=value
	castbar.Max=max
	castbar.BarShield=barshield
	castbar.IconOverlay=iconoverlay

	castbar.Parent=parent
	
	NPA_CastWarning_SetFrame(castbar)
	
	table_insert(NPA_CastWarning_Frame,castbar)

	frame["CastWarning"]=castbar

end

function NPA_CastWarning:ApplyConfig()
	NPA_Core:CheckConfigEntry("CastWarning",NPA_CastWarning_DefaultSettings)

	NPA_CastWarning_Config=NPA_Config["CastWarning"]
	
	for _,castbar in pairs(NPA_CastWarning_Frame) do
		NPA_CastWarning_SetFrame(castbar)
	end
	NPA_Core.RebuildFilters()
end

NPA_Core:AddHook("CastWarning",NPA_CastWarning_HookFrame)
NPA_Core:AddModule("CastWarning",NPA_CastWarning)
NPA_Core:HookUpdate("CastWarning",NPA_CastWarning_OnUpdate,1)
