-- Author      : Nogarder
-- Create Date : 2010/7/3 20:56:21
--config
local floor=floor
local GetTime=GetTime
local pairs=pairs
local strfind=string.find
local table_insert=table.insert

local NPA_AutoHide={}
local bit_band=bit.band



local NPA_AutoHide_DefaultSetting={
	["AutoHide_FadeHostile"]=1,
	["AutoHide_HostileFadeLevel"]=0.5,
	["AutoHide_NonHostileFadeLevel"]=0,
	["AutoHide_FadeNonHostile"]=1,

	["AutoHide_HostilePlayerFilter"]={
		["ShowHaveBuff"]=0,
		["ShowHaveDebuff"]=1,
		["ShowHaveRaidIcon"]=0,
		["DefaultFade"]=0,
		["ShowTarget"]=1,
		["ShowPetTarget"]=1,
		["ShowMouseOver"]=1,
		["ShowTargetingMe"]=0,
		["ShowTargetingPet"]=1,
		["ShowCastingOnMe"]=1,
		["ShowCrowdControl"]=1,
		["ShowCasting"]=0,
		["ShowQuestMark"]=1,
		["ShowFocus"]=1,
		["ShowInRange"]=0,
		["WithCounterSpell"]=1,
		["LowHealth"]=0,
		["CoolDown"]=0,
		["Arena"]=0,
		["Threat"]=1,
		["TargetCount"]=0,
		["IsTotem"]=0,
		DeepCheck=1,
		},
	["AutoHide_NonHostilePlayerFilter"]={
		["ShowHaveBuff"]=0,
		["ShowHaveDebuff"]=1,
		["ShowHaveRaidIcon"]=0,
		["DefaultFade"]=0,
		["ShowTarget"]=1,
		["ShowPetTarget"]=1,
		["ShowMouseOver"]=1,
		["ShowTargetingMe"]=0,
		["ShowTargetingPet"]=1,
		["ShowCastingOnMe"]=1,
		["ShowCrowdControl"]=1,
		["ShowCasting"]=0,
		["ShowQuestMark"]=1,
		["ShowFocus"]=1,
		["ShowInRange"]=0,
		["WithCounterSpell"]=1,
		["LowHealth"]=0,
		["CoolDown"]=0,
		["Arena"]=0,
		["Threat"]=1,
		["TargetCount"]=0,
		["IsTotem"]=0,
		DeepCheck=1,
		},
	["AutoHide_HostileNonPlayerFilter"]={
		["ShowHaveBuff"]=0,
		["ShowHaveDebuff"]=1,
		["ShowHaveRaidIcon"]=0,
		["DefaultFade"]=0,
		["ShowTarget"]=1,
		["ShowPetTarget"]=1,
		["ShowMouseOver"]=1,
		["ShowTargetingMe"]=0,
		["ShowTargetingPet"]=1,
		["ShowCastingOnMe"]=1,
		["ShowCrowdControl"]=1,
		["ShowCasting"]=0,
		["ShowQuestMark"]=1,
		["ShowFocus"]=1,
		["ShowInRange"]=0,
		["WithCounterSpell"]=1,
		["LowHealth"]=0,
		["CoolDown"]=0,
		["Arena"]=0,
		["Threat"]=1,
		["TargetCount"]=0,
		["IsTotem"]=0,
		DeepCheck=1,
		},
	["AutoHide_NonHostileNonPlayerFilter"]={
		["ShowPet"]=0,
		["ShowHaveBuff"]=0,
		["ShowHaveDebuff"]=1,
		["ShowHaveRaidIcon"]=0,
		["DefaultFade"]=0,
		["ShowTarget"]=1,
		["ShowPetTarget"]=1,
		["ShowMouseOver"]=1,
		["ShowTargetingMe"]=0,
		["ShowTargetingPet"]=1,
		["ShowCastingOnMe"]=1,
		["ShowCrowdControl"]=1,
		["ShowCasting"]=0,
		["ShowQuestMark"]=1,
		["ShowFocus"]=1,
		["ShowInRange"]=0,
		["WithCounterSpell"]=1,
		["LowHealth"]=0,
		["CoolDown"]=0,
		["Arena"]=0,
		["Threat"]=1,
		["TargetCount"]=0,
		["IsTotem"]=0,
		DeepCheck=1,
		},

	["AutoHide_GlobalFilter"]={
		["ShowPet"]=0,
		["ShowHaveBuff"]=0,
		["ShowHaveDebuff"]=1,
		["ShowHaveRaidIcon"]=0,
		["DefaultFade"]=0,
		["ShowTarget"]=1,
		["ShowPetTarget"]=1,
		["ShowMouseOver"]=1,
		["ShowTargetingMe"]=0,
		["ShowTargetingPet"]=1,
		["ShowCastingOnMe"]=1,
		["ShowCrowdControl"]=1,
		["ShowCasting"]=0,
		["ShowQuestMark"]=1,
		["ShowFocus"]=1,
		["ShowInRange"]=0,
		["WithCounterSpell"]=1,
		["LowHealth"]=0,
		["CoolDown"]=0,
		["Arena"]=0,
		["Threat"]=1,
		["TargetCount"]=0,
		["IsTotem"]=0,
		DeepCheck=1,
		},
	["AutoHide_SeparateFade"]={
		["Aura"]=1,
		["CastWarning"]=1,
		["ClassIcon"]=1,
		["ComboPoint"]=1,
		["CoolDown"]=1,
		["CrowdControl"]=1,
		["HealthBar"]=1,
		["ManaBar"]=1,
		["RaidIcon"]=1,
		["Speed"]=1,
		["Target"]=1,
		["Threat"]=1,
		["QuestMark"]=1,
		["RangeCheck"]=1,
		["CounterSpell"]=1,
		["ClassInfo"]=1,
		["TargetCount"]=1,
		["ShieldWatch"]=1,
		["exCombat"]=1,
		["RoleCheck"]=1,
		DeepCheck=1,
		},

	["AutoHide_EnableSeparateFade"]=0,
	["AutoHide_NameWhiteList"]={},
	["AutoHide_NameBlackList"]={},
	["AutoHide_ListPowerMatch"]=0,
	["AutoHide_UseWhiteList"]=0,
	["AutoHide_UseBlackList"]=0,

	["AutoHide_UseZoom"]=0,
	["AutoHide_ZoomTarget"]=1,
	["AutoHide_ZoomFocus"]=1,
	["AutoHide_ZoomHighThreatPlayer"]=1,
	["AutoHide_ZoomTankingPlayer"]=1,
	["AutoHide_ZoomHighThreatMob"]=1,
	["AutoHide_ZoomTankingMob"]=1,
	["AutoHide_ZoomLowThreatPlayer"]=1,
	["AutoHide_ZoomLowThreatMob"]=1,

	["AutoHide_ZoomFilter"]=1,
	["AutoHide_ZoomHostilePlayer"]=1,
	["AutoHide_ZoomNonHostilePlayer"]=1,
	["AutoHide_ZoomHostileNonPlayer"]=1,
	["AutoHide_ZoomNonHostileNonPlayer"]=1,
	["AutoHide_ZoomHostilePet"]=1,
	["AutoHide_ZoomNonHostilePet"]=1,
	["AutoHide_ZoomHostileGuardian"]=1,
	["AutoHide_ZoomNonHostileGuardian"]=1,
	["AutoHide_ZoomSpecial"]=1,

	["AutoHide_ZoomTargetLevel"]=1.25,
	["AutoHide_ZoomFocusLevel"]=1.25,
	["AutoHide_ZoomHighThreatPlayerLevel"]=1.25,
	["AutoHide_ZoomTankingPlayerLevel"]=1.25,
	["AutoHide_ZoomHighThreatMobLevel"]=1.25,
	["AutoHide_ZoomTankingMobLevel"]=1.25,
	["AutoHide_ZoomLowThreatPlayerLevel"]=1.25,
	["AutoHide_ZoomLowThreatMobLevel"]=1.25,


	["AutoHide_ZoomFilterLevel"]=1.25,
	["AutoHide_ZoomHostilePlayerLevel"]=1.25,
	["AutoHide_ZoomNonHostilePlayerLevel"]=1.25,
	["AutoHide_ZoomHostileNonPlayerLevel"]=1.25,
	["AutoHide_ZoomNonHostileNonPlayerLevel"]=1.25,
	["AutoHide_ZoomHostilePetLevel"]=1.25,
	["AutoHide_ZoomNonHostilePetLevel"]=1.25,
	["AutoHide_ZoomHostileGuardianLevel"]=1.25,
	["AutoHide_ZoomNonHostileGuardianLevel"]=1.25,
	["AutoHide_ZoomSpecialLevel"]=1.25,

	["AutoHide_ZoomList"]={},
	["AutoHide_UseZoomList"]=0,

	["AutoHide_BlackListFadeLevel"]=0.5,
	["AutoHide_SpecficFadeBlackList"]=0,
	["AutoHide_SpecficFadeNonPlayer"]=0,
	["AutoHide_NonPlayer_HostileFadeLevel"]=0.5,
	["AutoHide_NonPlayer_NonHostileFadeLevel"]=0,

	["AutoHide_SeparateFilter"]=0,
	}
local NPA_AutoHide_Config=NPA_AutoHide_DefaultSetting
local NPA_AutoHide_GlobalSize
local NPA_AutoHide_FadeFunction=function() end
local NPA_AutoHide_FadeList={}
local NPA_AutoHide_FrameList={}

local NPA_AutoHide_ZoomFilterList={}
local NPA_AutoHide_GlobalFilter={GUIDBased={},Normal={}}
local NPA_AutoHide_HostilePlayerFilter={GUIDBased={},Normal={}}
local NPA_AutoHide_NonHostilePlayerFilter={GUIDBased={},Normal={}}
local NPA_AutoHide_HostileNonPlayerFilter={GUIDBased={},Normal={}}
local NPA_AutoHide_NonHostileNonPlayerFilter={GUIDBased={},Normal={}}
local NPA_AutoHide_PetCache={}


function NPA_AutoHide:ResetConfig()
	NPA_Config["AutoHide"]=CopyTable(NPA_AutoHide_DefaultSetting)
end



local function NPA_AutoHide_BuildFilterList(options)
	local filter={GUIDBased={},Normal={}}
	--guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,isarena

	--totem
	if(options["IsTotem"]==1)then
		filter.Normal["ClassIcon"]=function(_,_,_,_,frame)
			local classicon=frame["ClassIcon"]
			if(classicon and classicon.IsTotem==1)then
				return 1
			end
		end
	end

	--low health
	if(options["AutoHide_Filter_LowHealth"]==1)then
		filter.Normal["LowHealth"]=function(_,_,_,_,frame)
			local health=frame["HealthBar"]
			if(health and health.LowHealth:IsShown())then
				return 1
			end
		end
	end

	--questmark
	if(options["ShowQuestMark"]==1)then
		filter.Normal["QuestMark"]=function(_,_,_,_,frame)
			local questmark=frame["QuestMark"]
			if(questmark and questmark:IsShown())then
				return 1
			end
		end
	end

	--raid icon
	if(options["ShowHaveRaidIcon"]==1)then
		filter.Normal["RaidIcon"]=function(_,_,_,_,frame)
			local raidicon=frame["RaidIcon"]
			if(raidicon and raidicon:IsShown())then
				return 1
			end
		end
	end
	
	--fade when have no target
	if(options["DefaultFade"]==1)then
		filter.Normal["DefaultFade"]=function(_,_,_,guids)
			if(guids.Target==0)then
				return 1
			end
		end
	end

	--in arena
	if(options["Arena"]==1)then
		filter.Normal["Arena"]=function(_,_,_,_,_,_,_,_,_,isarena)
			if(isarena==1)then
				return 1
			end
		end
	end


	--guid based
	--have buff
	if(options["ShowHaveBuff"]==1)then
		filter.GUIDBased["HaveBuff"]=function(_,_,_,_,frame)
			local aura=frame["Aura"]
			if(aura and aura:IsShown() and aura.BuffMain:IsShown())then
				return 1
			end
		end
	end
	--have debuff
	if(options["ShowHaveDebuff"]==1)then
		filter.GUIDBased["HaveDebuff"]=function(_,_,_,_,frame)
			local aura=frame["Aura"]
			if(aura and aura:IsShown() and aura.DebuffMain:IsShown())then
				return 1
			end
		end
	end
	--cc
	if(options["ShowCrowdControl"]==1)then
		filter.GUIDBased["CrowdControl"]=function(_,_,_,_,frame)
			local crowdcontrol=frame["CrowdControl"]
			if(crowdcontrol and crowdcontrol:IsShown())then
				return 1
			end
		end
	end
	--cooldown
	if(options["CoolDown"]==1)then
		filter.GUIDBased["CoolDown"]=function(_,_,_,_,frame)
			local cooldown=frame["CoolDown"]
			if(cooldown and cooldown:IsShown())then
				return 1
			end
		end
	end

	--is my target
	if(options["ShowTarget"]==1)then
		filter.GUIDBased["Target"]=function(guid,_,_,guids)
			if(guid==guids.Target)then
				return 1
			end
		end
		filter[1]="ABCDEFG"
	end
	--is mouseover
	if(options["ShowMouseOver"]==1)then
		filter.GUIDBased["MouseOver"]=function(guid,_,_,guids)
			if(guid==guids.Mouseover)then
				return 1
			end
		end
	end

	--is focus
	if(options["ShowFocus"]==1)then
		filter.GUIDBased["Focus"]=function(guid,_,_,guids)
			if(guid==guids.Focus)then
				return 1
			end
		end
	end
	--is pettarget
	if(options["ShowPetTarget"]==1)then
		filter.GUIDBased["PetTarget"]=function(guid,_,_,guids)
			if(guid==guids.Pet)then
				return 1
			end
		end
	end
	--rangecheck
	if(options["ShowInRange"]==1)then
		filter.GUIDBased["InRange"]=function(_,_,_,_,frame)
			local rangecheck=frame["RangeCheck"]
			if(rangecheck and rangecheck.RangeType==1)then
				return 1
			end
		end
	end

	--counterspell
	if(options["WithCounterSpell"]==1)then
		filter.GUIDBased["CounterSpell"]=function(_,_,_,_,frame)
			local counterspell=frame["CounterSpell"]
			if(counterspell and counterspell:IsShown())then
				return 1
			end
		end
	end

	--threat
	if(options["Threat"]==1)then
		filter.GUIDBased["Threat"]=function(_,_,_,_,frame)
			local threat=frame["Threat"]
			if(threat and threat:IsShown())then
				return 1
			end
		end
	end

	--targetcount
	if(options["TargetCount"]==1)then
		filter.GUIDBased["TargetCount"]=function(_,_,_,_,frame)
			local targetcount=frame["TargetCount"]
			if(targetcount and targetcount:IsShown())then
				return 1
			end
		end
	end

	--casting
	if(options["ShowCasting"]==1)then
		filter.GUIDBased["CastWarning"]=function(_,_,_,_,frame)
			local castwarning=frame["CastWarning"]
			if(castwarning and castwarning:IsShown())then
				return 1
			end
		end
	end

	--casting on me
	if(options["ShowCastingOnMe"]==1)then
		filter.GUIDBased["CastOnMe"]=function(_,unitdata,selfguid,_,frame)
			local castwarning=frame["CastWarning"]
			if(castwarning and castwarning:IsShown() and unitdata and unitdata.Target and unitdata.Target.TargetGUID==selfguid)then
				return 1
			end
		end
	end
	
	--targeting me

	if(options["ShowTargetingMe"]==1)then
		filter.GUIDBased["TargetingMe"]=function(_,unitdata,selfguid,_,_,_,_,_,recentUpdated)
			if(recentUpdated and unitdata and unitdata.Target and unitdata.Target.TargetGUID==selfguid)then
				return 1
			end	
		end
	end

	--targeting pet
	if(options["ShowTargetingPet"]==1)then
		filter.GUIDBased["TargetingPet"]=function(_,unitdata,selfguid,guids,_,_,_,_,recentUpdated)
			if(recentUpdated and unitdata and unitdata.Target and unitdata.Target.TargetGUID==guids.Pet)then
				return 1
			end	
		end
	end

	--is pet
	if(options["ShowPet"]==1)then
		filter.GUIDBased["IsPet"]=function(guid,_,_,guids)
			if(guids.Pet==guid)then
				return 1
			end
		end
	end

	return filter
end


local function NPA_AutoHide_BuildZoomFilterList()
	NPA_AutoHide_ZoomFilterList={}
	local filter=NPA_AutoHide_ZoomFilterList
	if(NPA_AutoHide_Config["AutoHide_UseZoom"]==1)then
		if(NPA_AutoHide_Config["AutoHide_ZoomTarget"]==1)then
			filter["ZoomTarget"]=function(guid,_,_,guids)
				if(guid==guids.Target)then
					return NPA_AutoHide_Config["AutoHide_ZoomTargetLevel"]
				end
			end
		end

		if(NPA_AutoHide_Config["AutoHide_ZoomFocus"]==1)then
			filter["ZoomFocus"]=function(guid,_,_,guids)
				if(guid==guids.Focus)then
					return NPA_AutoHide_Config["AutoHide_ZoomFocusLevel"]
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomHighThreatPlayer"]==1)then
			filter["ZoomHighThreatPlayer"]=function(_,_,_,_,frame,_,isplayer)
				local threat=frame["Threat"]
				if(threat)then
					local type=threat.ThreatType
					if((type==1) and isplayer==1)then
						return NPA_AutoHide_Config["AutoHide_ZoomHighThreatPlayerLevel"]
					end
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomHighThreatMob"]==1)then
			filter["ZoomHighThreatMob"]=function(_,_,_,_,frame,_,isplayer)
				local threat=frame["Threat"]
				if(threat)then
					local type=threat.ThreatType
					if((type==1 or type==2) and isplayer~=1)then
						return NPA_AutoHide_Config["AutoHide_ZoomHighThreatMobLevel"]
					end
				end
			end
		end

		if(NPA_AutoHide_Config["AutoHide_ZoomLowThreatPlayer"]==1)then
			filter["ZoomLowThreatPlayer"]=function(_,_,_,_,frame,_,isplayer)
				local threat=frame["Threat"]
				if(threat)then
					local type=threat.ThreatType
					if((type==0) and isplayer==1)then
						return NPA_AutoHide_Config["AutoHide_ZoomLowThreatPlayerLevel"]
					end
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomLowThreatMob"]==1)then
			filter["ZoomLowThreatMob"]=function(_,_,_,_,frame,_,isplayer)
				local threat=frame["Threat"]
				if(threat)then
					local type=threat.ThreatType
					if((type==0 or type==2) and isplayer~=1)then
						return NPA_AutoHide_Config["AutoHide_ZoomLowThreatMobLevel"]
					end
				end
			end
		end

		if(NPA_AutoHide_Config["AutoHide_ZoomTankingPlayer"]==1)then
			filter["ZoomTankingPlayer"]=function(_,_,_,_,frame,_,isplayer)
				local threat=frame["Threat"]
				if(threat.ThreatType==3 and isplayer==1)then
					return NPA_AutoHide_Config["AutoHide_ZoomTankingPlayerLevel"]
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomTankingMob"]==1)then
			filter["ZoomTankingMob"]=function(_,_,_,_,frame,_,isplayer)
				local threat=frame["Threat"]
				if(threat.ThreatType==3 and isplayer~=1)then
					return NPA_AutoHide_Config["AutoHide_ZoomTankingMobLevel"]
				end
			end
		end

		if(NPA_AutoHide_Config["AutoHide_ZoomHostilePlayer"]==1)then
			filter["ZoomHostilePlayer"]=function(_,_,_,_,_,hostile,isplayer)
				if(hostile~=0 and isplayer==1)then
					return NPA_AutoHide_Config["AutoHide_ZoomHostilePlayerLevel"]
				end
			end
		end

		if(NPA_AutoHide_Config["AutoHide_ZoomNonHostilePlayer"]==1)then
			filter["ZoomNonHostilePlayer"]=function(_,_,_,_,_,hostile,isplayer)
				if(hostile==0 and isplayer==1)then
					return NPA_AutoHide_Config["AutoHide_ZoomNonHostilePlayerLevel"]
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomHostileNonPlayer"]==1)then
			filter["ZoomHostileNonPlayer"]=function(_,_,_,_,_,hostile,isplayer,_,_,_,_,typecache,special)
				if(hostile~=0 and isplayer~=1 and typecache==nil and special==nil)then
					return NPA_AutoHide_Config["AutoHide_ZoomHostileNonPlayerLevel"]
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomNonHostileNonPlayer"]==1)then
			filter["ZoomNonHostileNonPlayer"]=function(_,_,_,_,_,hostile,isplayer,_,_,_,_,typecache,special)
				if(hostile==0 and isplayer~=1 and typecache==nil and special==nil)then
					return NPA_AutoHide_Config["AutoHide_ZoomNonHostileNonPlayerLevel"]
				end
			end
		end

		if(NPA_AutoHide_Config["AutoHide_ZoomFilter"]==1)then
			filter["ZoomNonHostileNonPlayer"]=function(_,_,_,_,_,_,_,_,_,_,alpha)
				if(alpha==1)then
					return NPA_AutoHide_Config["AutoHide_ZoomFilterLevel"]
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_UseZoomList"]==1)then
			filter["ZoomList"]=function(_,_,_,_,_,_,_,default)
				local name=default.NameText:GetText() or 0
				local value=NPA_AutoHide_Config["AutoHide_ZoomList"][name]
				if(value)then
					return value
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomHostilePet"]==1)then
			filter["ZoomHostilePet"]=function(_,_,_,_,_,_,_,_,_,_,_,typecache)
				if(typecache==5)then
					return NPA_AutoHide_Config["AutoHide_ZoomHostilePetLevel"]
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomNonHostilePet"]==1)then
			filter["ZoomNonHostilePet"]=function(_,_,_,_,_,_,_,_,_,_,_,typecache)
				if(typecache==2)then
					return NPA_AutoHide_Config["AutoHide_ZoomNonHostilePetLevel"]
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomHostileGuardian"]==1)then
			filter["ZoomHostileGuardian"]=function(_,_,_,_,_,_,_,_,_,_,_,typecache)
				if(typecache==6)then
					return NPA_AutoHide_Config["AutoHide_ZoomHostileGuardianLevel"]
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomNonHostileGuardian"]==1)then
			filter["ZoomNonHostileGuardian"]=function(_,_,_,_,_,_,_,_,_,_,_,typecache)
				if(typecache==3)then
					return NPA_AutoHide_Config["AutoHide_ZoomNonHostileGuardianLevel"]
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_ZoomSpecial"]==1)then
			filter["ZoomSpecial"]=function(_,_,_,_,_,_,_,_,_,_,_,_,special)
				if(special)then
					return NPA_AutoHide_Config["AutoHide_ZoomSpecialLevel"]
				end
			end
		end

	end

end

function NPA_AutoHide:ApplySize()
	NPA_AutoHide_GlobalSize=NPA_Config["Core"]["GlobalSize"]
end

function NPA_AutoHide:ApplyConfig()
	NPA_Core:CheckConfigEntry("AutoHide",NPA_AutoHide_DefaultSetting)

	NPA_AutoHide_Config=NPA_Config["AutoHide"]
	NPA_AutoHide_GlobalSize=NPA_Config["Core"]["GlobalSize"]


	----build filter list

	NPA_AutoHide_BuildZoomFilterList()

	NPA_AutoHide_GlobalFilter=NPA_AutoHide_BuildFilterList(NPA_AutoHide_Config["AutoHide_GlobalFilter"])
	NPA_AutoHide_HostilePlayerFilter=NPA_AutoHide_BuildFilterList(NPA_AutoHide_Config["AutoHide_HostilePlayerFilter"])
	NPA_AutoHide_NonHostilePlayerFilter=NPA_AutoHide_BuildFilterList(NPA_AutoHide_Config["AutoHide_NonHostilePlayerFilter"])
	NPA_AutoHide_HostileNonPlayerFilter=NPA_AutoHide_BuildFilterList(NPA_AutoHide_Config["AutoHide_HostileNonPlayerFilter"])
	NPA_AutoHide_NonHostileNonPlayerFilter=NPA_AutoHide_BuildFilterList(NPA_AutoHide_Config["AutoHide_NonHostileNonPlayerFilter"])


	local modules=NPA_Core:GetCurrentModules()
	for _,frame in pairs(NPA_AutoHide_FrameList) do
		frame:SetAlpha(1)
		for key,_ in pairs(modules) do
			if(frame[key])then
				frame[key]:SetAlpha(1)
			end
		end
	end

	if(NPA_AutoHide_Config["AutoHide_EnableSeparateFade"]==1)then
		local modules=NPA_Core:GetCurrentModules()
		NPA_AutoHide_FadeList={}
		for key,_ in pairs(modules) do
			if(NPA_AutoHide_Config["AutoHide_SeparateFade"][key]==1)then
				NPA_AutoHide_FadeList[key]=1
			end
		end

		NPA_AutoHide_FadeFunction=function(alpha,frame)
			for key,_ in pairs(NPA_AutoHide_FadeList) do
				local swap=frame[key]
				if(swap)then
					swap:SetAlpha(alpha)
				end
			end

			end
	else

		NPA_AutoHide_FadeFunction=function(alpha,frame)
			frame:SetAlpha(alpha)
			end
	end

end


local function NPA_AutoHide_CheckNameList(name)
	if(NPA_AutoHide_Config["AutoHide_ListPowerMatch"]==1)then --hard search
		if(NPA_AutoHide_Config["AutoHide_UseWhiteList"]==1)then
			for key,value in pairs(NPA_AutoHide_Config["AutoHide_NameWhiteList"]) do
				if(value==1 and (strfind(name,key) or strfind(key,name)))then
					return 1
				end
			end
		end
		if(NPA_AutoHide_Config["AutoHide_UseBlackList"]==1)then
			for key,value in pairs(NPA_AutoHide_Config["AutoHide_NameBlackList"]) do
				if(value==1 and (strfind(name,key) or strfind(key,name)))then
					return 2
				end
			end
		end

	else
		if(NPA_AutoHide_Config["AutoHide_UseWhiteList"]==1 and NPA_AutoHide_Config["AutoHide_NameWhiteList"][name]==1)then
			return 1
		elseif(NPA_AutoHide_Config["AutoHide_UseBlackList"]==1 and NPA_AutoHide_Config["AutoHide_NameBlackList"][name]==1)then
			return 2
		end
	end
	
	return nil
			
end


local function NPA_AutoHide_GetAlpha(guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,isarena)
	local filterlist,hostilefadelevel,nonhostilefadelevel

	--get filter list
	if(NPA_AutoHide_Config["AutoHide_SeparateFilter"]==1)then
		if(isplayer==1)then
			if(hostile==1)then
				filterlist=NPA_AutoHide_HostilePlayerFilter
			else
				filterlist=NPA_AutoHide_NonHostilePlayerFilter
			end
		else
			if(hostile==1)then
				filterlist=NPA_AutoHide_HostileNonPlayerFilter
			else
				filterlist=NPA_AutoHide_NonHostileNonPlayerFilter
			end
		end
	else
		filterlist=NPA_AutoHide_GlobalFilter
	end

	if((isplayer~=1) and NPA_AutoHide_Config["AutoHide_SpecficFadeNonPlayer"]==1)then
		hostilefadelevel=NPA_AutoHide_Config["AutoHide_NonPlayer_HostileFadeLevel"]
		nonhostilefadelevel=NPA_AutoHide_Config["AutoHide_NonPlayer_NonHostileFadeLevel"]
	else
		hostilefadelevel=NPA_AutoHide_Config["AutoHide_HostileFadeLevel"]
		nonhostilefadelevel=NPA_AutoHide_Config["AutoHide_NonHostileFadeLevel"]
	end

	--name filter	--check namelist
	local name=default.NameText:GetText()
	if(NPA_AutoHide_CheckNameList(name)==1)then
		return 1
	elseif(NPA_AutoHide_CheckNameList(name)==2)then
		if(NPA_AutoHide_Config["AutoHide_SpecficFadeBlackList"]==1)then
			return NPA_AutoHide_Config["AutoHide_BlackListFadeLevel"]
		else
			if(hostile==1)then
				return hostilefadelevel
			else
				return nonhostilefadelevel
			end
		end
	end

	---get fade level by reaction
	local fadelevel
	if(hostile~=0)then --hostile
		if(NPA_AutoHide_Config["AutoHide_FadeHostile"]==1)then
			fadelevel=hostilefadelevel
		else
			fadelevel=1
		end
	else -----non hostile
		if(NPA_AutoHide_Config["AutoHide_FadeNonHostile"]==1)then
			fadelevel=nonhostilefadelevel
		else
			fadelevel=1
		end
	end

	for _,filterfunc in pairs(filterlist.Normal) do
		local value=filterfunc(guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,isarena)
		if(value)then
			return value
		end
	end
	if(guid~=0)then
		for _,filterfunc in pairs(filterlist.GUIDBased) do
			local value=filterfunc(guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,isarena)
			if(value)then
				return value
			end
		end
	end
		
	return fadelevel
end	

local function NPA_AutoHide_GetZoom(guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,isarena,alpha,typecache)
	local special
	if(default.BossIcon:IsShown())then
		special=1
	elseif(unitdata)then
		local class=unitdata.Classification
		if(class=="worldboss" or class=="rareelite" or class=="rare")then
			special=1
		end
	else
		local r,g,b=default.StateIcon:GetVertexColor()
		if(r<0.9 or g<0.9 or b<0.9)then
			special=1
		end
	end

	for _,func in pairs(NPA_AutoHide_ZoomFilterList) do
		local value=func(guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,isarena,alpha,typecache,special)
		if(value)then
			return value
		end
	end
	return NPA_AutoHide_GlobalSize
end

                               --nTime,main,guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,recentGuessed,isfriend,isguild,isparty,israid,isinstance,NPA_Core_IsInArena,NPA_Core_IsInBattleground,typecache)
local function NPA_AutoHide_OnUpdate(_,main,guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,_,_,_,_,_,_,isarena,_,typecache)
	if(not default)then
		return
	end

	local alpha=NPA_AutoHide_GetAlpha(guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,isarena)
	if(alpha<0)then
		alpha=0
	end
	NPA_AutoHide_FadeFunction(alpha,frame)

	local zoom=NPA_AutoHide_GetZoom(guid,unitdata,selfguid,guids,frame,hostile,isplayer,default,recentUpdated,isarena,alpha,typecache)
	if(zoom<0.01)then
		zoom=0.01
	end

	frame:SetScale(zoom)
end

local function NPA_AutoHide_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_AutoHide_Hook",frame)
	main:SetHeight(1)
	main:SetWidth(1)
	main:SetPoint("CENTER",frame,"CENTER",0,0)
	main:Show()
	
	frame["AutoHide"]=main
	table_insert(NPA_AutoHide_FrameList,frame)
end


NPA_Core:AddHook("AutoHide",NPA_AutoHide_HookFrame)
NPA_Core:AddModule("AutoHide",NPA_AutoHide)
NPA_Core:HookUpdate("AutoHide",NPA_AutoHide_OnUpdate,1)
