﻿-- Author      : Nogarder
-- Create Date : 2010/6/29 1:48:01
local NPA_Aura={}
local NPA_Aura_Frame={}

--config

local NPA_Aura_DefaultSetting={
		["Aura_BarData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=0.5,
			Texture="Interface\\TargetingFrame\\UI-StatusBar",
			TextureBlend="ADD",
			RAngle=90,
			DeepCheck=1,
			Top=0,
			Bottom=1,
			Left=0,
			Right=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Aura_IconData"]={
			OffsetX=0,
			OffsetY=0,
			Height=20,
			Width=20,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Aura_BackgroundData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="Interface\\Addons\\NPA\\texture\\blank",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Aura_HighlightData"]={
			OffsetX=0,
			OffsetY=0,
			Height=24,
			Width=24,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=0.3,
			Texture="Interface\\Addons\\NPA\\texture\\blank",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Aura_OverlayData"]={
			OffsetX=0,
			OffsetY=0,
			Height=22,
			Width=22,
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			Texture="",
			TextureBlend="BLEND",
			Left=0,
			Right=1,
			Top=0,
			Bottom=1,
			RAngle=0,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
		["Aura_TimeData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=5,
			OffsetY=-5,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	

		["Aura_StackData"]={
			Font=GameFontNormal:GetFont(),
			OffsetX=-5,
			OffsetY=5,
			ShadowX=1,
			ShadowY=-1,
			Size=11,
			Mode="OUTLINE",
			Red=1,
			Green=1,
			Blue=1,
			Alpha=1,
			DeepCheck=1,
			Anchor="CENTER",
			ToAnchor="CENTER",
			},
	
		["Aura_OffsetX"]=0,
		["Aura_OffsetY"]=15,
		["Aura_BuffOffsetX"]=0,
		["Aura_BuffOffsetY"]=0,
		["Aura_DebuffOffsetX"]=0,
		["Aura_DebuffOffsetY"]=0,
		["Aura_MaxBuff"]=6,
		["Aura_MaxDebuff"]=6,
		["Aura_BuffPerRow"]=6,
		["Aura_DebuffPerRow"]=6,
		["Aura_FrameAnchor"]="CENTER",
		["Aura_BuffFrameAnchor"]="BOTTOM",
		["Aura_DebuffFrameAnchor"]="BOTTOM",
		["Aura_BuffAnchorDebuff"]=0,
		["Aura_DebuffAnchorBuff"]=1,
		["Aura_GapX"]=1,
		["Aura_GapY"]=1,
		["Aura_BuffGrowUpward"]=1,
		["Aura_BuffGrowRightward"]=1,
		["Aura_DebuffGrowUpward"]=1,
		["Aura_DebuffGrowRightward"]=1,
		["Aura_Font"]=GameFontNormal:GetFont(),

		["Aura_Filter_Buff_FromSelf"]=1,
		["Aura_Filter_Buff_FromPet"]=0,
		["Aura_Filter_Buff_FromTarget"]=0,
		["Aura_Filter_Buff_FromFocus"]=0,
		["Aura_Filter_Buff_FromMouseover"]=0,
		["Aura_Filter_Buff_FromHostilePlayer"]=0,
		["Aura_Filter_Buff_FromHostileNonPlayer"]=0,
		["Aura_Filter_Buff_FromNonHostilePlayer"]=0,
		["Aura_Filter_Buff_FromNonHostileNonPlayer"]=0,

		["Aura_Filter_Buff_ToSelf"]=1,
		["Aura_Filter_Buff_ToPet"]=0,
		["Aura_Filter_Buff_ToTarget"]=0,
		["Aura_Filter_Buff_ToFocus"]=0,
		["Aura_Filter_Buff_ToMouseover"]=0,
		["Aura_Filter_Buff_ToHostilePlayer"]=0,
		["Aura_Filter_Buff_ToHostileNonPlayer"]=0,
		["Aura_Filter_Buff_ToNonHostilePlayer"]=0,
		["Aura_Filter_Buff_ToNonHostileNonPlayer"]=0,

		["Aura_Filter_Debuff_FromSelf"]=1,
		["Aura_Filter_Debuff_FromPet"]=0,
		["Aura_Filter_Debuff_FromTarget"]=0,
		["Aura_Filter_Debuff_FromFocus"]=0,
		["Aura_Filter_Debuff_FromMouseover"]=0,
		["Aura_Filter_Debuff_FromHostilePlayer"]=0,
		["Aura_Filter_Debuff_FromHostileNonPlayer"]=0,
		["Aura_Filter_Debuff_FromNonHostilePlayer"]=0,
		["Aura_Filter_Debuff_FromNonHostileNonPlayer"]=0,

		["Aura_Filter_Debuff_ToSelf"]=1,
		["Aura_Filter_Debuff_ToPet"]=1,
		["Aura_Filter_Debuff_ToTarget"]=1,
		["Aura_Filter_Debuff_ToFocus"]=1,
		["Aura_Filter_Debuff_ToMouseover"]=1,
		["Aura_Filter_Debuff_ToHostilePlayer"]=1,
		["Aura_Filter_Debuff_ToHostileNonPlayer"]=1,
		["Aura_Filter_Debuff_ToNonHostilePlayer"]=1,
		["Aura_Filter_Debuff_ToNonHostileNonPlayer"]=1,

		["Aura_Filter_BuffTime"]=60,
		["Aura_Filter_DebuffTime"]=60,
		["Aura_Filter_WhiteList_Spellid"]={},
		["Aura_Filter_BlackList_Spellid"]={},

		["Aura_Filter_Magic"]=1,
		["Aura_Filter_Poison"]=1,
		["Aura_Filter_Curse"]=1,
		["Aura_Filter_Disease"]=1,
		["Aura_Filter_Stealable"]=1,
		["Aura_Filter_Physic"]=1,
		["Aura_Filter_Enrage"]=1,
		["Aura_Filter_Highlight_Magic"]=0,
		["Aura_Filter_Highlight_Posion"]=0,
		["Aura_Filter_Highlight_Disease"]=0,
		["Aura_Filter_Highlight_Physic"]=0,
		["Aura_Filter_Highlight_Curse"]=0,
		["Aura_Filter_Highlight_Enrage"]=0,
		["Aura_Filter_Highlight_Stealable"]=1,
		["Aura_Filter_Highlight_Mine"]=1,
		["Aura_Filter_Highlight_Other"]=0,
		["Aura_Highlight"]=1,
		["Aura_Decile"]=0,
		["Aura_BuffScale"]=1,
		["Aura_DebuffScale"]=1,
		["Aura_UseHighlightScale"]=0,
		["Aura_HighlightScale"]=1,
		["Aura_ScaleList"]={},
		["Aura_HighlightList"]={},
		["Aura_ShowBar"]=1,
		["Aura_Decile"]=0,
		["Aura_ColorHighlight"]=0,
		["Aura_ColorBackground"]=0,
		["Aura_ColorMagic"]=1,
		["Aura_ColorPosion"]=1,
		["Aura_ColorDisease"]=1,
		["Aura_ColorCurse"]=1,
		["Aura_ColorPhysic"]=1,
		["Aura_ColorEnrage"]=1,
		["Aura_ColorBar"]=0,
		["Aura_ColorBarByTime"]=0,
		["Aura_ColorTextByTime"]=0,

		["Aura_AlterDecile"]=0,
		["Aura_SortBySpellid"]=0,
		["Aura_SortByTimeleft"]=0,
		["Aura_SortByCaster"]=0,
	}

local NPA_Aura_Config=NPA_Aura_DefaultSetting

function NPA_Aura:ResetConfig()
	NPA_Config["Aura"]=CopyTable(NPA_Aura_DefaultSetting)
end

function NPA_Aura:ClearData()

end


-- get global functions
local pairs = pairs
local floor = floor
local table_insert = table.insert
local table_getn = table.getn
local table_sort = table.sort
local tostring=tostring
local mod = mod
local abs = abs

local SpellData=NPA_Core.SpellData

local NPA_Aura_FilterFromFunc={
	["BUFF"]={},
	["DEBUFF"]={}
	}
local NPA_Aura_FilterToFunc={
	["BUFF"]={},
	["DEBUFF"]={}
	}

local NPA_Aura_SchoolFilter={}
local NPA_Aura_SchoolFilterFunc={}
local NPA_Aura_SchoolColor={}
local NPA_Aura_ColorFunc={}
local NPA_Aura_TextFunc={}
local NPA_Aura_HighlightSchool={}
local NPA_Aura_HighlightFunc={}

local whitelistid={}
local blacklistid={}
local NPA_Aura_WhiteListFromFunc={}
local NPA_Aura_WhiteListToFunc={}
local NPA_Aura_BlackListFromFunc={}
local NPA_Aura_BlackListToFunc={}


local NPA_Aura_CheckFuncList={
	["Self"]=function(selfguid,_,guid)
			if(guid==selfguid)then
				return 1
			end
		end,
	
	["Pet"]=function(_,guids,guid)
			if(guid==guids.Pet)then
				return 1
			end
		end,
	
	["Focus"]=function(_,guids,guid)
			if(casterguid==guids.Focus)then
				return 1
			end
		end,
	["Target"]=function(_,guids,guid)
			if(guid==guids.Target)then
				return 1
			end
		end,
	["Mouseover"]=function(_,guids,guid)
			if(guid==guids.Mouseover)then
				return 1
			end
		end,
	
	["HostilePlayer"]=function(_,_,_,hostile,isplayer)
			if(hostile~=0 and isplayer==1)then
					return 1
			end
		end,

	["NonHostilePlayer"]=function(_,_,_,hostile,isplayer)
			if(hostile==0 and isplayer==1)then
					return 1
			end
		end,

	["HostileNonPlayer"]=function(_,_,_,hostile,isplayer)
			if(hostile~=0 and isplayer~=1)then
					return 1
			end
		end,
	["NonHostileNonPlayer"]=function(_,_,_,hostile,isplayer)
			if(hostile==0 and isplayer~=1)then
					return 1
			end
		end,

}

local function NPA_Aura_BuildFilter()
	----------school filter
	NPA_Aura_SchoolFilter={}
	if(NPA_Aura_Config["Aura_Filter_Magic"]==1)then
		NPA_Aura_SchoolFilter["Magic"]=1
	end
	if(NPA_Aura_Config["Aura_Filter_Poison"]==1)then
		NPA_Aura_SchoolFilter["Poison"]=1
	end
		if(NPA_Aura_Config["Aura_Filter_Disease"]==1)then
		NPA_Aura_SchoolFilter["Disease"]=1
	end
	if(NPA_Aura_Config["Aura_Filter_Curse"]==1)then
		NPA_Aura_SchoolFilter["Curse"]=1
	end
	if(NPA_Aura_Config["Aura_Filter_Enrage"]==1)then
		NPA_Aura_SchoolFilter[""]=1 ---blizzard's strange bug
	end
	if(NPA_Aura_Config["Aura_Filter_Physic"]==1)then
		NPA_Aura_SchoolFilter["Physic"]=1 
	end

	NPA_Aura_SchoolFilterFunc={}
	if(NPA_Aura_Config["Aura_Filter_Magic"]==1
		or NPA_Aura_Config["Aura_Filter_Poison"]==1
		or NPA_Aura_Config["Aura_Filter_Disease"]==1
		or NPA_Aura_Config["Aura_Filter_Curse"]==1
		or NPA_Aura_Config["Aura_Filter_Enrage"]==1
		or NPA_Aura_Config["Aura_Filter_Physic"]==1)then

			NPA_Aura_SchoolFilterFunc["School"]=function(data)
					if(NPA_Aura_SchoolFilter[(data.School or "Physic")]==1)then
						return 1
					end
				end
	end
	if(NPA_Aura_Config["Aura_Filter_Stealable"]==1)then
			NPA_Aura_SchoolFilterFunc["Stealable"]=function(data)
				if(data.Stealable)then
					return 1
				end
			end
	end

--------------------------------------------------------------------------
----------------aura from filter
	NPA_Aura_FilterFromFunc={
		["BUFF"]={},
		["DEBUFF"]={}
	}
	-----------------------------
	-------buff filters
	if(NPA_Aura_Config["Aura_Filter_Buff_FromSelf"]==1)then
		NPA_Aura_FilterFromFunc["BUFF"]["Self"]=NPA_Aura_CheckFuncList["Self"]
	end

	if(NPA_Aura_Config["Aura_Filter_Buff_FromPet"]==1)then
		NPA_Aura_FilterFromFunc["BUFF"]["Pet"]=NPA_Aura_CheckFuncList["Pet"]
	end

	if(NPA_Aura_Config["Aura_Filter_Buff_FromFocus"]==1)then
		NPA_Aura_FilterFromFunc["BUFF"]["Focus"]=NPA_Aura_CheckFuncList["Focus"]
	end
	if(NPA_Aura_Config["Aura_Filter_Buff_FromTarget"]==1)then
		NPA_Aura_FilterFromFunc["BUFF"]["Target"]=NPA_Aura_CheckFuncList["Target"]
	end
	if(NPA_Aura_Config["Aura_Filter_Buff_FromMouseoverBuff"]==1)then
		NPA_Aura_FilterFromFunc["BUFF"]["Mouseover"]=NPA_Aura_CheckFuncList["Mouseover"]
	end

	if(NPA_Aura_Config["Aura_Filter_Buff_FromHostilePlayer"]==1)then
		NPA_Aura_FilterFromFunc["BUFF"]["HostilePlayer"]=NPA_Aura_CheckFuncList["HostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Buff_FromHostileNonPlayer"]==1)then
		NPA_Aura_FilterFromFunc["BUFF"]["HostileNonPlayer"]=NPA_Aura_CheckFuncList["HostileNonPlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Buff_FromNonHostilePlayer"]==1)then
		NPA_Aura_FilterFromFunc["BUFF"]["NonHostilePlayer"]=NPA_Aura_CheckFuncList["NonHostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Buff_FromNonHostileNonPlayer"]==1)then
		NPA_Aura_FilterFromFunc["BUFF"]["NonHostileNonPlayer"]=NPA_Aura_CheckFuncList["NonHostileNonPlayer"]
	end

	-------------------------
	--------debuff
	if(NPA_Aura_Config["Aura_Filter_Debuff_FromSelf"]==1)then
		NPA_Aura_FilterFromFunc["DEBUFF"]["Self"]=NPA_Aura_CheckFuncList["Self"]
	end

	if(NPA_Aura_Config["Aura_Filter_Debuff_FromPet"]==1)then
		NPA_Aura_FilterFromFunc["DEBUFF"]["Pet"]=NPA_Aura_CheckFuncList["Pet"]
	end

	if(NPA_Aura_Config["Aura_Filter_Debuff_FromFocus"]==1)then
		NPA_Aura_FilterFromFunc["DEBUFF"]["Focus"]=NPA_Aura_CheckFuncList["Focus"]
	end
	if(NPA_Aura_Config["Aura_Filter_Debuff_FromTarget"]==1)then
		NPA_Aura_FilterFromFunc["DEBUFF"]["Target"]=NPA_Aura_CheckFuncList["Target"]
	end
	if(NPA_Aura_Config["Aura_Filter_Debuff_FromMouseoverDebuff"]==1)then
		NPA_Aura_FilterFromFunc["DEBUFF"]["Mouseover"]=NPA_Aura_CheckFuncList["Mouseover"]
	end

	if(NPA_Aura_Config["Aura_Filter_Debuff_FromHostilePlayer"]==1)then
		NPA_Aura_FilterFromFunc["DEBUFF"]["HostilePlayer"]=NPA_Aura_CheckFuncList["HostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Debuff_FromHostileNonPlayer"]==1)then
		NPA_Aura_FilterFromFunc["DEBUFF"]["HostileNonPlayer"]=NPA_Aura_CheckFuncList["HostileNonPlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Debuff_FromNonHostilePlayer"]==1)then
		NPA_Aura_FilterFromFunc["DEBUFF"]["NonHostilePlayer"]=NPA_Aura_CheckFuncList["NonHostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Debuff_FromNonHostileNonPlayer"]==1)then
		NPA_Aura_FilterFromFunc["DEBUFF"]["NonHostileNonPlayer"]=NPA_Aura_CheckFuncList["NonHostileNonPlayer"]
	end

	------------------------
	-----------aura to func
	NPA_Aura_FilterToFunc={
	["BUFF"]={},
	["DEBUFF"]={}
	}
	----------buff
	-------------------------
	if(NPA_Aura_Config["Aura_Filter_Buff_ToSelf"]==1)then
		NPA_Aura_FilterToFunc["BUFF"]["Self"]=NPA_Aura_CheckFuncList["Self"]
	end

	if(NPA_Aura_Config["Aura_Filter_Buff_ToPet"]==1)then
		NPA_Aura_FilterToFunc["BUFF"]["Pet"]=NPA_Aura_CheckFuncList["Pet"]
	end

	if(NPA_Aura_Config["Aura_Filter_Buff_ToFocus"]==1)then
		NPA_Aura_FilterToFunc["BUFF"]["Focus"]=NPA_Aura_CheckFuncList["Focus"]
	end
	if(NPA_Aura_Config["Aura_Filter_Buff_ToTarget"]==1)then
		NPA_Aura_FilterToFunc["BUFF"]["Target"]=NPA_Aura_CheckFuncList["Target"]
	end
	if(NPA_Aura_Config["Aura_Filter_Buff_ToMouseoverBuff"]==1)then
		NPA_Aura_FilterToFunc["BUFF"]["Mouseover"]=NPA_Aura_CheckFuncList["Mouseover"]
	end

	if(NPA_Aura_Config["Aura_Filter_Buff_ToHostilePlayer"]==1)then
		NPA_Aura_FilterToFunc["BUFF"]["HostilePlayer"]=NPA_Aura_CheckFuncList["HostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Buff_ToHostileNonPlayer"]==1)then
		NPA_Aura_FilterToFunc["BUFF"]["HostileNonPlayer"]=NPA_Aura_CheckFuncList["HostileNonPlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Buff_ToNonHostilePlayer"]==1)then
		NPA_Aura_FilterToFunc["BUFF"]["NonHostilePlayer"]=NPA_Aura_CheckFuncList["NonHostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Buff_ToNonHostileNonPlayer"]==1)then
		NPA_Aura_FilterToFunc["BUFF"]["NonHostileNonPlayer"]=NPA_Aura_CheckFuncList["NonHostileNonPlayer"]
	end

	-------------------------
	--------debuff
	if(NPA_Aura_Config["Aura_Filter_Debuff_ToSelf"]==1)then
		NPA_Aura_FilterToFunc["DEBUFF"]["Self"]=NPA_Aura_CheckFuncList["Self"]
	end

	if(NPA_Aura_Config["Aura_Filter_Debuff_ToPet"]==1)then
		NPA_Aura_FilterToFunc["DEBUFF"]["Pet"]=NPA_Aura_CheckFuncList["Pet"]
	end

	if(NPA_Aura_Config["Aura_Filter_Debuff_ToFocus"]==1)then
		NPA_Aura_FilterToFunc["DEBUFF"]["Focus"]=NPA_Aura_CheckFuncList["Focus"]
	end
	if(NPA_Aura_Config["Aura_Filter_Debuff_ToTarget"]==1)then
		NPA_Aura_FilterToFunc["DEBUFF"]["Target"]=NPA_Aura_CheckFuncList["Target"]
	end
	if(NPA_Aura_Config["Aura_Filter_Debuff_ToMouseoverDebuff"]==1)then
		NPA_Aura_FilterToFunc["DEBUFF"]["Mouseover"]=NPA_Aura_CheckFuncList["Mouseover"]
	end

	if(NPA_Aura_Config["Aura_Filter_Debuff_ToHostilePlayer"]==1)then
		NPA_Aura_FilterToFunc["DEBUFF"]["HostilePlayer"]=NPA_Aura_CheckFuncList["HostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Debuff_ToHostileNonPlayer"]==1)then
		NPA_Aura_FilterToFunc["DEBUFF"]["HostileNonPlayer"]=NPA_Aura_CheckFuncList["HostileNonPlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Debuff_ToNonHostilePlayer"]==1)then
		NPA_Aura_FilterToFunc["DEBUFF"]["NonHostilePlayer"]=NPA_Aura_CheckFuncList["NonHostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_Debuff_ToNonHostileNonPlayer"]==1)then
		NPA_Aura_FilterToFunc["DEBUFF"]["NonHostileNonPlayer"]=NPA_Aura_CheckFuncList["NonHostileNonPlayer"]
	end
	----------------school color 

	NPA_Aura_SchoolColor={}
	if(NPA_Aura_Config["Aura_ColorMagic"]==1)then
		NPA_Aura_SchoolColor["Magic"]={r=0,g=0,b=1}
	end
	if(NPA_Aura_Config["Aura_ColorPosion"]==1)then
		NPA_Aura_SchoolColor["Poison"]={r=0,g=1,b=0}
	end
	if(NPA_Aura_Config["Aura_ColorCurse"]==1)then
		NPA_Aura_SchoolColor["Curse"]={r=1,g=0,b=1}
	end
	if(NPA_Aura_Config["Aura_ColorDisease"]==1)then
		NPA_Aura_SchoolColor["Disease"]={r=0.6,g=0.6,b=0}
	end
	if(NPA_Aura_Config["Aura_ColorEnrage"]==1)then
		NPA_Aura_SchoolColor[""]={r=1,g=0,b=0}
	end
	if(NPA_Aura_Config["Aura_ColorPhysic"]==1)then
		NPA_Aura_SchoolColor["Physic"]={r=1,g=1,b=0}
	end

	if(NPA_Aura_Config["Aura_ColorBackground"]==1)then
		NPA_Aura_ColorFunc["Background"]=function(main,color)
			local bg=main.Background
			bg:SetVertexColor(bg.R*color.r,bg.G*color.g,bg.B*color.b)
		end
	end
	if(NPA_Aura_Config["Aura_ColorBar"]==1)then
		NPA_AUra_ColorFunc["Bar"]=function(main,color)
			local bar=main.Bar
			bar:SetVertexColor(bar.R*color.r,bar.G*color.g,bar.B*color.b)
		end
	end

	--------------------------text func
	NPA_Aura_TextFunc={}
	if(NPA_Aura_Config["Aura_Decile"]==1)then
		if(NPA_Aura_Config["Aura_AlterDecile"]==1)then
			NPA_Aura_TextFunc["Decile"]=function(timeleft)
				if(timeleft<2)then
					return floor(timeleft*10)/10
				elseif(timeleft>99)then
					return "*"
				else
					return floor(timeleft)
				end
			end
		else
			NPA_Aura_TextFunc["Decile"]=function(timeleft)
				if(timeleft<2)then
					return "."..floor(timeleft*10)
				elseif(timeleft>99)then
					return "*"
				else
					return floor(timeleft)
				end
			end
		end
	else
		NPA_Aura_TextFunc["Decile"]=function(timeleft)
			if(timeleft>99)then
				return "*"
			else
				return floor(timeleft)
			end
		end
	end

	if(NPA_Aura_Config["Aura_ColorTextByTime"]==1)then
		NPA_Aura_TextFunc["Color"]=function(timeleft)
				if(timeleft>60)then
					return "|cff00ff00"
				elseif(timeleft>3)then
					return "|cffffff00"
				else
					return "|cffff0000"
				end
			end
	end
	----------------------------------
	-------------------list func
	-----------whitelist
	--from
	NPA_Aura_WhiteListFromFunc={}
	if(NPA_Aura_Config["Aura_Filter_WhiteList_FromSelf"]==1)then
		NPA_Aura_WhiteListFromFunc["Self"]=NPA_Aura_CheckFuncList["Self"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_FromTarget"]==1)then
		NPA_Aura_WhiteListFromFunc["Target"]=NPA_Aura_CheckFuncList["Target"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_FromFocus"]==1)then
		NPA_Aura_WhiteListFromFunc["Focus"]=NPA_Aura_CheckFuncList["Focus"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_FromPet"]==1)then
		NPA_Aura_WhiteListFromFunc["Pet"]=NPA_Aura_CheckFuncList["Pet"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_FromMouseover"]==1)then
		NPA_Aura_WhiteListFromFunc["Mouseover"]=NPA_Aura_CheckFuncList["Mouseover"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_FromHostilePlayer"]==1)then
		NPA_Aura_WhiteListFromFunc["HostilePlayer"]=NPA_Aura_CheckFuncList["HostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_FromHostileNonPlayer"]==1)then
		NPA_Aura_WhiteListFromFunc["HostileNonPlayer"]=NPA_Aura_CheckFuncList["HostileNonPlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_FromNonHostilePlayer"]==1)then
		NPA_Aura_WhiteListFromFunc["NonHostilePlayer"]=NPA_Aura_CheckFuncList["NonHostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_FromNonHostileNonPlayer"]==1)then
		NPA_Aura_WhiteListFromFunc["NonHostileNonPlayer"]=NPA_Aura_CheckFuncList["NonHostileNonPlayer"]
	end
	----to
	NPA_Aura_WhiteListToFunc={}
	if(NPA_Aura_Config["Aura_Filter_WhiteList_ToSelf"]==1)then
		NPA_Aura_WhiteListToFunc["Self"]=NPA_Aura_CheckFuncList["Self"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_ToTarget"]==1)then
		NPA_Aura_WhiteListToFunc["Target"]=NPA_Aura_CheckFuncList["Target"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_ToFocus"]==1)then
		NPA_Aura_WhiteListToFunc["Focus"]=NPA_Aura_CheckFuncList["Focus"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_ToPet"]==1)then
		NPA_Aura_WhiteListToFunc["Pet"]=NPA_Aura_CheckFuncList["Pet"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_ToMouseover"]==1)then
		NPA_Aura_WhiteListToFunc["Mouseover"]=NPA_Aura_CheckFuncList["Mouseover"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_ToHostilePlayer"]==1)then
		NPA_Aura_WhiteListToFunc["HostilePlayer"]=NPA_Aura_CheckFuncList["HostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_ToHostileNonPlayer"]==1)then
		NPA_Aura_WhiteListToFunc["HostileNonPlayer"]=NPA_Aura_CheckFuncList["HostileNonPlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_ToNonHostilePlayer"]==1)then
		NPA_Aura_WhiteListToFunc["NonHostilePlayer"]=NPA_Aura_CheckFuncList["NonHostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_WhiteList_ToNonHostileNonPlayer"]==1)then
		NPA_Aura_WhiteListToFunc["NonHostileNonPlayer"]=NPA_Aura_CheckFuncList["NonHostileNonPlayer"]
	end

	---------blacklist
	----from
	NPA_Aura_BlackListFromFunc={}
	if(NPA_Aura_Config["Aura_Filter_BlackList_FromSelf"]==1)then
		NPA_Aura_BlackListFromFunc["Self"]=NPA_Aura_CheckFuncList["Self"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_FromTarget"]==1)then
		NPA_Aura_BlackListFromFunc["Target"]=NPA_Aura_CheckFuncList["Target"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_FromFocus"]==1)then
		NPA_Aura_BlackListFromFunc["Focus"]=NPA_Aura_CheckFuncList["Focus"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_FromPet"]==1)then
		NPA_Aura_BlackListFromFunc["Pet"]=NPA_Aura_CheckFuncList["Pet"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_FromMouseover"]==1)then
		NPA_Aura_BlackListFromFunc["Mouseover"]=NPA_Aura_CheckFuncList["Mouseover"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_FromHostilePlayer"]==1)then
		NPA_Aura_BlackListFromFunc["HostilePlayer"]=NPA_Aura_CheckFuncList["HostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_FromHostileNonPlayer"]==1)then
		NPA_Aura_BlackListFromFunc["HostileNonPlayer"]=NPA_Aura_CheckFuncList["HostileNonPlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_FromNonHostilePlayer"]==1)then
		NPA_Aura_BlackListFromFunc["NonHostilePlayer"]=NPA_Aura_CheckFuncList["NonHostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_FromNonHostileNonPlayer"]==1)then
		NPA_Aura_BlackListFromFunc["NonHostileNonPlayer"]=NPA_Aura_CheckFuncList["NonHostileNonPlayer"]
	end
	--to
	NPA_Aura_BlackListToFunc={}
	if(NPA_Aura_Config["Aura_Filter_BlackList_ToSelf"]==1)then
		NPA_Aura_BlackListToFunc["Self"]=NPA_Aura_CheckFuncList["Self"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_ToTarget"]==1)then
		NPA_Aura_BlackListToFunc["Target"]=NPA_Aura_CheckFuncList["Target"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_ToFocus"]==1)then
		NPA_Aura_BlackListToFunc["Focus"]=NPA_Aura_CheckFuncList["Focus"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_ToPet"]==1)then
		NPA_Aura_BlackListToFunc["Pet"]=NPA_Aura_CheckFuncList["Pet"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_ToMouseover"]==1)then
		NPA_Aura_BlackListToFunc["Mouseover"]=NPA_Aura_CheckFuncList["Mouseover"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_ToHostilePlayer"]==1)then
		NPA_Aura_BlackListToFunc["HostilePlayer"]=NPA_Aura_CheckFuncList["HostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_ToHostileNonPlayer"]==1)then
		NPA_Aura_BlackListToFunc["HostileNonPlayer"]=NPA_Aura_CheckFuncList["HostileNonPlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_ToNonHostilePlayer"]==1)then
		NPA_Aura_BlackListToFunc["NonHostilePlayer"]=NPA_Aura_CheckFuncList["NonHostilePlayer"]
	end
	if(NPA_Aura_Config["Aura_Filter_BlackList_ToNonHostileNonPlayer"]==1)then
		NPA_Aura_BlackListToFunc["NonHostileNonPlayer"]=NPA_Aura_CheckFuncList["NonHostileNonPlayer"]
	end


	-------------
	-------highlight school check
	NPA_Aura_HighlightSchoolList={}
	if(NPA_Aura_Config["Aura_Filter_Highlight_Magic"]==1)then
		NPA_Aura_HighlightSchooListl["Magic"]=1
	end
	if(NPA_Aura_Config["Aura_Filter_Highlight_Poison"]==1)then
		NPA_Aura_HighlightSchoolList["Poison"]=1
	end
	if(NPA_Aura_Config["Aura_Filter_Highlight_Curse"]==1)then
		NPA_Aura_HighlightSchoolList["Curse"]=1
	end
	if(NPA_Aura_Config["Aura_Filter_Highlight_Disease"]==1)then
		NPA_Aura_HighlightSchoolList["Disease"]=1
	end
	if(NPA_Aura_Config["Aura_Filter_Highlight_Enrage"]==1)then
		NPA_Aura_HighlightSchoolList[""]=1
	end
	if(NPA_Aura_Config["Aura_Filter_Highlight_Physic"]==1)then
		NPA_Aura_HighlightSchoolList["Physic"]=1
	end

	---------------highlight func
	NPA_Aura_HighlightFunc={}
	if(NPA_Aura_Config["Aura_Filter_Highlight_Magic"]==1 or
		NPA_Aura_Config["Aura_Filter_Highlight_Poison"]==1 or
		NPA_Aura_Config["Aura_Filter_Highlight_Curse"]==1 or
		NPA_Aura_Config["Aura_Filter_Highlight_Disease"]==1 or
		NPA_Aura_Config["Aura_Filter_Highlight_Enrage"]==1 or 
		NPA_Aura_Config["Aura_Filter_Highlight_Physic"]==1)then
		
			NPA_Aura_HighlightFunc["School"]=function(school)
					if(NPA_Aura_HighlightSchoolList[(school or "Physic")])then
						return 1
					end
				end
	end

	if(NPA_Aura_Config["Aura_Filter_Highlight_Stealable"]==1)then
		NPA_Aura_HighlightFunc["Stealable"]=function(_,_,_,data)
				if(data.Stealable)then
					return 1
				end
			end
	end

	if(NPA_Aura_Config["Aura_Filter_Highlight_Mine"]==1)then
		NPA_Aura_HighlightFunc["Mine"]=function(_,casterguid,selfguid)
				if(casterguid==selfguid)then
					return 1
				end
			end
	end

	if(NPA_Aura_Config["Aura_Filter_Highlight_Other"]==1)then
		NPA_Aura_HighlightFunc["Other"]=function(_,casterguid,selfguid)
				if(casterguid~=selfguid)then
					return 1
				end
			end
	end
end

local GetUnitData=NPA_Core.GetUnitData

local function NPA_Aura_ApplyFromFilter(id,aura,type,selfguid,guids,nTime)
	local casterguid=aura.CasterGUID
	local casterdata=GetUnitData(casterguid)
	local casterhostile
	local casterisplayer
	if(casterdata)then
		if(not casterdata.IsFriend)then
			casterhostile=1
		end
		casterisplayer=casterdata.IsPlayer
	end

	--blacklist check
	if(blacklistid[id])then
		for name,_ in pairs(blacklistid[id].List1) do
			if(NPA_Aura_CheckFuncList[name](selfguid,guids,casterguid,tohostile,toplayer))then
				return nil
			end
		end
	end

	--whitelist check
	if(whitelistid[id])then
		for name,_ in pairs(whitelistid[id].List1) do
			if(NPA_Aura_CheckFuncList[name](selfguid,guids,casterguid,tohostile,toplayer))then
				return 1
			end
		end
	end

	----time filter
	local timefilter
	if(type=="BUFF")then
		timefilter=NPA_Aura_Config["Aura_Filter_BuffTime"]
	else
		timefilter=NPA_Aura_Config["Aura_Filter_DebuffTime"]
	end
	if(timefilter>0)then
		local extime=aura.ExpirationTime
		if(extime)then
			local timeleft=extime-nTime
			if(timeleft<0 or (timeleft>timefilter))then
				return nil
			end
		else
			return nil
		end
	end

	--main check
	for name,func in pairs(NPA_Aura_FilterFromFunc[type])do
		if(func(selfguid,guids,casterguid,casterhostile,casterisplayer)==1)then
			return 1
		end
	end
end
---------------------------------
local function NPA_Aura_ApplyToFilter(type,guid,selfguid,guids,tohostile,toplayer,id)
	--blacklist check
	if(blacklistid[id])then
		for name,_ in pairs(blacklistid[id].List2) do
			if(NPA_Aura_CheckFuncList[name](selfguid,guids,guid,tohostile,toplayer))then
				return nil
			end
		end
	end

	--whitelist check
	if(whitelistid[id])then
		for name,_ in pairs(whitelistid[id].List2) do
			if(NPA_Aura_CheckFuncList[name](selfguid,guids,guid,tohostile,toplayer))then
				return 1
			end
		end
	end

	--------------
	for _,func in pairs(NPA_Aura_FilterToFunc[type])do
		if(func(selfguid,guids,guid,tohostile,toplayer)==1)then
			return 1
		end
	end
end

--------------------------------

local NPA_ManageBar=NPA_Core.ManageBar


local function NPA_Aura_HighlightCheck(data,selfguid)
	
end
local function NPA_Aura_SetIconDisplay(main,data,aura,nTime,selfguid,highlight,scale,highlightscale,highlightlist,maxduration,showbar)
	--Frame,Icon,Text,Count
	--icon
	main.Icon:SetTexture(data.Icon)

	--school filter

	local color=NPA_Aura_SchoolColor[(aura.School or "Physic")] or {r=1,g=1,b=1}
	
	for _,func in pairs(NPA_Aura_ColorFunc) do
		func(main,color)
	end

	--highlight
	local s

	if(highlight==1)then
		local casterguid=aura.CasterGUID

		local pass
		for _,func in pairs(NPA_Aura_HighlightFunc) do
			if(func(school,casterguid,selfguid,data))then
				pass=1
				break
			end
		end
		if(pass or highlightlist)then
			local hl=main.Highlight
			hl:Show()
			s=highlightscale or scale or 1

			if(NPA_Aura_Config["Aura_ColorHighlight"]==1)then
				hl:SetVertexColor(hl.R*color.r,hl.G*color.g,hl.B*color.b)
			else
				hl:SetVertexColor(hl.R,hl.G,hl.B)
			end

		else
			s=scale or 1
			main.Highlight:Hide()
		end
	else
		s=scale or 1
		main.Highlight:Hide()
	end

	--timeleft
	local extime=aura.ExpirationTime
	if(extime and extime~=0) then
		local timeleft=extime-nTime
		local timetext
		
		timetext=NPA_Aura_TextFunc["Decile"](timeleft)
		if(NPA_Aura_TextFunc["Color"])then
			timetext=NPA_Aura_TextFunc["Color"](timeleft)..timetext
		end

		main.Text:SetText(timetext)

		--bar
		if(showbar==1)then
			local guid=aura.CasterGUID or 0
			if(maxduration and maxduration[guid] and maxduration[guid]>0)then
				local bar=main.Bar
				bar.Percent=timeleft/maxduration[guid]
				NPA_ManageBar(nil,bar)

				if(NPA_Aura_Config["Aura_ColorBarByTime"]==1)then
					local percent=bar.Percent
					bar:SetVertexColor(bar.R*(1-percent),bar.G*percent,0)
				end
			else
				main.Bar:Hide()
			end
		else
			main.Bar:Hide()
		end
	else
		main.Bar:Hide()
		main.Text:SetText(nil)
	end


	--count
	local stack=aura.Count
	if(stack and stack>1) then
		main.Stack:SetText(stack)
	else
		main.Stack:SetText(nil)
	end

	main.Scale=s
	main:SetScale(s)
	main:Show()
end

local function NPA_Aura_SetAuraDisplay(main,count,max,row,width,height,gapx,gapy)
	count=count-1
	if(count<1)then
		main:SetWidth(1)
		main:SetHeight(1)
		main:Hide()
		return 0
	elseif(count>max)then
		count=max
	end

	local zheight=height+gapy
	local zwidth=width+gapx

	local bwidth=zwidth*main.Icon[1].Scale
	local bheight=zheight*main.Icon[1].Scale

	local brow=bwidth
	local bcol=0

	local lastheight=bheight

	local icons=main.Icon

	for i=2,count do
		local icon=icons[i]
		if(mod(i,row)==1)then
			bcol=bcol+bheight
			if(bwidth>brow)then
				brow=bwidth
			end
			bwidth=zwidth*icon.Scale

			icon:SetPoint(icon.Anchor,icons[icon.AnchorId],icon.Anchor,0,bheight/icon.Scale*icon.Dir)

			bheight=zheight*icon.Scale
		else
			bwidth=bwidth+zwidth*icon.Scale
			local h=zheight*icon.Scale
			if(h>bheight)then
				bheight=h
			end
		end
	end

	if(count<=row)then
		brow=bwidth
	end
	bcol=bcol+bheight

	main:SetWidth(brow)
	main:SetHeight(bcol)
	main:Show()

	return 1
end

local function NPA_Aura_SortBySpellid(a,b)
	return (a.spellid or 1)>(b.spellid or 0)
end

local function NPA_Aura_SortByTimeleft(a,b)
	return (a.aura.ExpirationTime or 1)>(b.aura.ExpirationTime or 0)
end
local function NPA_Aura_SortByCaster(a,b)
	return (a.aura.CasterGUID or 1)>(b.aura.CasterGUID or 0)
end

local maxdurationcache=NPA_Core.Aura_Duration_Cache

local function NPA_Aura_OnUpdate(nTime,self,guid,unitdata,selfguid,guids,_,hostile,isplayer)
	local bufficons=self.BuffMain.Icon
	local debufficons=self.DebuffMain.Icon

	local buffcount=1
	local debuffcount=1
	local buffmax=NPA_Aura_Config["Aura_MaxBuff"]
	local debuffmax=NPA_Aura_Config["Aura_MaxDebuff"]
	--sort buff&debuff
	
	local bufflist={}
	local debufflist={}

	for spellid,auras in pairs(unitdata.Aura) do
		if(table_getn(auras)>0)then
			local data=SpellData[spellid]
			if(data)then
				local pass
				for _,func in pairs(NPA_Aura_SchoolFilterFunc) do
					if(func(data)==1)then
						pass=1
						break
					end
				end
				if(pass)then
					local type=data.Type
					local id=tostring(spellid) or ""
					if(NPA_Aura_ApplyToFilter(type,guid,selfguid,guids,hostile,isplayer,id)==1)then
						if(type=="DEBUFF" and debuffcount<=debuffmax) then
							for _,aura in pairs(auras) do
								if(debuffcount<=debuffmax and NPA_Aura_ApplyFromFilter(id,aura,type,selfguid,guids,nTime)==1)then
									table_insert(debufflist,{
										data=data,
										aura=aura,
										spellid=spellid,
										maxduration=maxdurationcache[spellid]
										})
									debuffcount=debuffcount+1
								end
							end
						elseif(type=="BUFF" and buffcount<=buffmax)then
							for _,aura in pairs(auras) do
								if(buffcount<=buffmax and NPA_Aura_ApplyFromFilter(id,aura,type,selfguid,guids,nTime)==1)then
									table_insert(bufflist,{
										data=data,
										aura=aura,
										spellid=spellid,
										maxduration=maxdurationcache[spellid]
										})
									buffcount=buffcount+1
								end
							end
						end
					end
				end
			end
		end
	end

	local hightlight=NPA_Aura_Config["Aura_Highlight"]
	local highlightscale
	if(NPA_Aura_Config["Aura_UseHighlightScale"]==1)then
		highlightscale=NPA_Aura_Config["Aura_HighlightScale"]
	end

	local scalelist=NPA_Aura_Config["Aura_ScaleList"]
	local highlightlist=NPA_Aura_Config["Aura_HighlightList"]
	local showbar=NPA_Aura_Config["Aura_ShowBar"]


	if(NPA_Aura_Config["Aura_SortBySpellid"]==1)then
		table_sort(bufflist,NPA_Aura_SortBySpellid)
		table_sort(debufflist,NPA_Aura_SortBySpellid)
	elseif(NPA_Aura_Config["Aura_SortByTimeleft"]==1)then
		table_sort(bufflist,NPA_Aura_SortByTimeleft)
		table_sort(debufflist,NPA_Aura_SortByTimeleft)
	elseif(NPA_Aura_Config["Aura_SortByCaster"]==1)then
		table_sort(bufflist,NPA_Aura_SortByCaster)
		table_sort(debufflist,NPA_Aura_SortByCaster)
	end

	for i=1,buffcount-1 do
		local aura=bufflist[i]
		local icon=bufficons[i]
--					main,     data,       aura,   nTime,selfguid,highlight,scale,                  highlightscale,highlightlist,              maxduration,     showbar)
		NPA_Aura_SetIconDisplay(icon,aura.data,aura.aura,nTime,selfguid,highlight,scalelist[aura.spellid],highlightscale,highlightlist[aura.spellid],aura.maxduration,showbar)
	end

	for i=1,debuffcount-1 do
		local aura=debufflist[i]
		local icon=debufficons[i]
		NPA_Aura_SetIconDisplay(icon,aura.data,aura.aura,nTime,selfguid,highlight,scalelist[aura.spellid],highlightscale,highlightlist[aura.spellid],aura.maxduration,showbar)
	end


	local bwidth=0
	local bheight=0

	local gapx=self.GapX
	local gapy=self.GapY
	local width=self.Width
	local height=self.Height

	for i=buffcount,NPA_Aura_Config["Aura_MaxBuff"] do 
		bufficons[i]:Hide()
	end
	for i=debuffcount,NPA_Aura_Config["Aura_MaxDebuff"] do
		debufficons[i]:Hide()
	end
	
	--aura displays
	
	local a1=NPA_Aura_SetAuraDisplay(self.BuffMain,buffcount,buffmax,NPA_Aura_Config["Aura_BuffPerRow"],width,height,gapx,gapy)
	local a2=NPA_Aura_SetAuraDisplay(self.DebuffMain,debuffcount,debuffmax,NPA_Aura_Config["Aura_DebuffPerRow"],width,height,gapx,gapy)
	if(a1==0 and a2==0)then
		self:Hide()
	else
		self:Show()
	end
end

local function NPA_Aura_CreateIcon(main)
	local frame=CreateFrame("Frame","NPA_Aura_IconFrame",main)
	frame:Hide()
		
	frame.Icon=frame:CreateTexture(nil,"BORDER",nil)
	frame.Icon:Show()
		
	frame.Background=frame:CreateTexture(nil,"BACKGROUND",nil)
	frame.Background:Show()

	frame.Text=frame:CreateFontString(nil,"OVERLAY",nil)
	frame.Text:Show()
		
	frame.Stack=frame:CreateFontString(nil,"OVERLAY",nil)
	frame.Stack:Show()

	frame.Overlay=frame:CreateTexture(nil,"OVERLAY",nil)
	frame.Overlay:Show()

	frame.Highlight=frame:CreateTexture(nil,"OVERLAY",nil)
	frame.Highlight:Hide()

	frame.Bar=frame:CreateTexture(nil,"ARTWORK",nil)
	frame.Bar:Hide()
	
	return frame
end



local function NPA_Aura_CreateBuffFrame(mainframe,num)
	local data={}
	for  i=1 ,num do
		data[i]=NPA_Aura_CreateIcon(mainframe)
	end
	return data
end

local ManageTexture=NPA_Core.TextureManager2
local ManageFont=NPA_Core.FontManager

local function NPA_Aura_SetBuffFrame(list,i,main,row,width,height,gapx,gapy,growup,growright)
	local frame=list[i]

	frame:ClearAllPoints()

	local index=i

	if(index==1)then
		local anchor
		if(growup~=1)then
			anchor="TOP"
		else
			anchor="BOTTOM"
		end
		if(growright~=1)then
			anchor=anchor.."RIGHT"
		else
			anchor=anchor.."LEFT"
		end
		frame:SetPoint(anchor,main,anchor,0,0)
	elseif(mod(index,row)==1 or row==1)then
		local anchor
		local anchorb
		if(growup~=1)then
			gapy=-gapy
			anchor="TOP"
			anchorb="BOTTOM"
		else
			anchor="BOTTOM"
			anchorb="TOP"
		end
		gapx=0
		if(growright~=1)then
			anchor=anchor.."RIGHT"
			anchorb=anchorb.."RIGHT"
		else
			anchor=anchor.."LEFT"
			anchorb=anchorb.."LEFT"
		end
		local id
		if(row==1)then
			id=index-1
		else
			id=((floor(index/row)-1)*row+1)
		end
		frame.AnchorId=id
		frame.Anchor=anchor
		frame.Dir=gapy/abs(gapy)
		frame:SetPoint(anchor,list[id],anchorb,gapx,gapy)
	else
		gapy=0
		if(growup~=1)then
			anchor="TOP"
			anchorb="TOP"
		else
			anchor="BOTTOM"
			anchorb="BOTTOM"
		end
		if(growright~=1)then
			gapx=-gapx
			anchor=anchor.."RIGHT"
			anchorb=anchorb.."LEFT"
		else
			anchor=anchor.."LEFT"
			anchorb=anchorb.."RIGHT"
		end
		frame:SetPoint(anchor,list[(index-1)],anchorb,gapx,gapy)
	end

	frame:SetHeight(height)
	frame:SetWidth(width)

	ManageTexture(nil,frame.Icon,NPA_Aura_Config["Aura_IconData"],frame)
	
	ManageTexture(nil,frame.Background,NPA_Aura_Config["Aura_BackgroundData"],frame)

	ManageTexture(nil,frame.Overlay,NPA_Aura_Config["Aura_OverlayData"],frame)

	ManageTexture(nil,frame.Highlight,NPA_Aura_Config["Aura_HighlightData"],frame)
	frame.Highlight:Hide()

	ManageTexture(nil,frame.Bar,NPA_Aura_Config["Aura_BarData"],frame,1)
	frame.Bar:Hide()


	ManageFont(nil,frame.Text,NPA_Aura_Config["Aura_TimeData"],frame)

	ManageFont(nil,frame.Stack,NPA_Aura_Config["Aura_StackData"],frame)
	
end

local function NPA_Aura_GetInversAnchor(anchor)
	if(anchor=="LEFT")then
		return "RIGHT"
	elseif(anchor=="RIGHT")then
		reruen "LEFT"
	elseif(anchor=="TOPLEFT")then
		return "BOTTOMRIGHT"
	elseif(anchor=="TOPRIGHT")then
		return "BOTTOMLEFT"
	elseif(anchor=="TOP")then
		return "BOTTOM"
	elseif(anchor=="BOTTOM")then
		return "TOP"
	elseif(anchor=="BOTTOMLEFT")then
		return "TOPRIGHT"
	elseif(anchor=="BOTTOMRIGHT")then
		return "TOPLEFT"
	end
end

local function NPA_Aura_SetFrame(auraframe)
	auraframe:ClearAllPoints()
	auraframe:SetPoint(NPA_Aura_Config["Aura_FrameAnchor"],auraframe:GetParent(),"CENTER",NPA_Aura_Config["Aura_OffsetX"],NPA_Aura_Config["Aura_OffsetY"])

	auraframe.BuffMain:ClearAllPoints()
	auraframe.DebuffMain:ClearAllPoints()
	local anchor=NPA_Aura_Config["Aura_BuffFrameAnchor"]
	if(NPA_Aura_Config["Aura_BuffAnchorDebuff"]==1)then
		auraframe.BuffMain:SetPoint(anchor,auraframe.DebuffMain,NPA_Aura_GetInversAnchor(anchor),NPA_Aura_Config["Aura_BuffOffsetX"],NPA_Aura_Config["Aura_BuffOffsetY"])
	else
		auraframe.BuffMain:SetPoint(anchor,auraframe,NPA_Aura_GetInversAnchor(anchor),NPA_Aura_Config["Aura_BuffOffsetX"],NPA_Aura_Config["Aura_BuffOffsetY"])
	end

	anchor=NPA_Aura_Config["Aura_DebuffFrameAnchor"]
	if(NPA_Aura_Config["Aura_DebuffAnchorBuff"]==1 and NPA_Aura_Config["Aura_BuffAnchorDebuff"]~=1)then
		auraframe.DebuffMain:SetPoint(anchor,auraframe.BuffMain,NPA_Aura_GetInversAnchor(anchor),NPA_Aura_Config["Aura_DebuffOffsetX"],NPA_Aura_Config["Aura_DebuffOffsetY"])
	else
		auraframe.DebuffMain:SetPoint(anchor,auraframe,NPA_Aura_GetInversAnchor(anchor),NPA_Aura_Config["Aura_DebuffOffsetX"],NPA_Aura_Config["Aura_DebuffOffsetY"])
	end

	auraframe.BuffMain:SetScale(NPA_Aura_Config["Aura_BuffScale"])
	auraframe.DebuffMain:SetScale(NPA_Aura_Config["Aura_DebuffScale"])

	local height=NPA_Aura_Config["Aura_IconData"].Height
	local width=NPA_Aura_Config["Aura_IconData"].Width

	local gapy=NPA_Aura_Config["Aura_GapY"]
	local gapx=NPA_Aura_Config["Aura_GapX"]

	auraframe.GapX=gapx
	auraframe.GapY=gapy
	auraframe.Height=height
	auraframe.Width=width

	for i=1,NPA_Aura_Config["Aura_MaxDebuff"] do
		if(not auraframe.DebuffMain.Icon[i])then
			auraframe.DebuffMain.Icon[i]=NPA_Aura_CreateIcon(auraframe.DebuffMain)
		end
		NPA_Aura_SetBuffFrame(auraframe.DebuffMain.Icon,i,auraframe.DebuffMain,NPA_Aura_Config["Aura_DebuffPerRow"],width,height,gapx,gapy,NPA_Aura_Config["Aura_DebuffGrowUpward"],NPA_Aura_Config["Aura_DebuffGrowRightward"])
	end

	for i=1,table_getn(auraframe.DebuffMain.Icon) do
		auraframe.DebuffMain.Icon[i]:Hide()
	end
	for i=1,NPA_Aura_Config["Aura_MaxBuff"] do
		if(not auraframe.BuffMain.Icon[i])then
			auraframe.BuffMain.Icon[i]=NPA_Aura_CreateIcon(auraframe.BuffMain)
		end

		NPA_Aura_SetBuffFrame(auraframe.BuffMain.Icon,i,auraframe.BuffMain,NPA_Aura_Config["Aura_BuffPerRow"],width,height,gapx,gapy,NPA_Aura_Config["Aura_BuffGrowUpward"],NPA_Aura_Config["Aura_BuffGrowRightward"])
	end


	for i=1,table_getn(auraframe.BuffMain.Icon) do
		auraframe.BuffMain.Icon[i]:Hide()
	end

end

local function NPA_Aura_HookFrame(frame)
	local main=CreateFrame("Frame","NPA_Aura_MainFrame",frame)
	main:SetWidth(1)
	main:SetHeight(1)
	main:Hide()

	main.BuffMain=CreateFrame("Frame","NPA_Aura_BuffMainFrame",main)

	main.DebuffMain=CreateFrame("Frame","NPA_Aura_DebuffMainFrame",main)

	
	main.BuffMain.Icon=NPA_Aura_CreateBuffFrame(main.BuffMain,NPA_Aura_Config["Aura_MaxBuff"])
	main.DebuffMain.Icon=NPA_Aura_CreateBuffFrame(main.DebuffMain,NPA_Aura_Config["Aura_MaxDebuff"])

	table_insert(NPA_Aura_Frame,main)
	NPA_Aura_SetFrame(main)

	frame["Aura"]=main
end


function NPA_Aura:ApplyConfig()
	NPA_Core:CheckConfigEntry("Aura",NPA_Aura_DefaultSetting)

	NPA_Aura_Config=NPA_Config["Aura"]

	for _,auraframe in pairs(NPA_Aura_Frame) do
		NPA_Aura_SetFrame(auraframe)
	end
	whitelistid=NPA_Aura_Config["Aura_Filter_WhiteList_Spellid"]
	blacklistid=NPA_Aura_Config["Aura_Filter_BlackList_Spellid"]
	
	for name,value in pairs(whitelistid) do
		if(type(value)~="table" or value.List1==nil or value.List2==nil)then
			whitelistid[name]=nil
		end
	end
	for name,value in pairs(blacklistid) do
		if(type(value)~="table"or value.List1==nil or value.List2==nil)then
			whitelistid[name]=nil
		end
	end

	NPA_Aura_BuildFilter()
end

--onload functions
NPA_Core:AddHook("Aura",NPA_Aura_HookFrame)
NPA_Core:AddModule("Aura",NPA_Aura)
NPA_Core:HookUpdate("Aura",NPA_Aura_OnUpdate,2)
