--[[
Warcraft Music Maker
by Motig, Vashj-EU
TODO: Features? Cleanup more, seperate interface.
--]]
local timeSinceLastUpdate = 0;
local updateFrame = CreateFrame('FRAME', 'Update_Frame');
local playStatus = 0;
local beatNumber = 1;
local oldBeatNumber = 1;
local playInterval = 0.10;
local soundToSet = 'No Sound Selected!';
local maxBeatNumber = 20;
local matchPattern = '[a-zA-Z0-9]*%.wav';
local soundLibrary = wmm.soundLibrary;

local soundFileButtons = {};
local soundEditFrames = {};	
local rhythmButtons = {};

local playTable = { [1] =	{['Muted'] = 0,
							['Sequence'] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
					[2] = 	{['Muted'] = 0,
							['Sequence'] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
					[3] = 	{['Muted'] = 0,
							['Sequence'] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
					[4] = 	{['Muted'] = 0,
							['Sequence'] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
					[5] = 	{['Muted'] = 0,
							['Sequence'] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
					[6] = 	{['Muted'] = 0,
							['Sequence'] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
					[7] = 	{['Muted'] = 0,
							['Sequence'] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
					[8] = 	{['Muted'] = 0,
							['Sequence'] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}} } 

local soundTable = {[1] = soundLibrary[math.random(#soundLibrary)],
					[2] = soundLibrary[math.random(#soundLibrary)],
					[3] = soundLibrary[math.random(#soundLibrary)],
					[4] = soundLibrary[math.random(#soundLibrary)],
					[5] = soundLibrary[math.random(#soundLibrary)],
					[6] = soundLibrary[math.random(#soundLibrary)],
					[7] = soundLibrary[math.random(#soundLibrary)],
					[8] = soundLibrary[math.random(#soundLibrary)]}

function Music_OnUpdate(self, elapsed)
	if playStatus == 1 then
		timeSinceLastUpdate = timeSinceLastUpdate + elapsed;
		if timeSinceLastUpdate >= playInterval then
			for i = 1, 8 do
				if playTable[i]['Sequence'][beatNumber] == 1 and playTable[i]['Muted'] == 0 then
					PlaySoundFile(soundTable[i], "MASTER");
				end			
				rhythmButtons[i]['tex'][oldBeatNumber]:SetTexture(0, 1, 0, 0);
				rhythmButtons[i]['tex'][beatNumber]:SetTexture(0, 1, 0, 0.5);
			end
		timeSinceLastUpdate = 0;
		oldBeatNumber = beatNumber;
		beatNumber = beatNumber + 1;
		if beatNumber > maxBeatNumber then beatNumber = 1 end
		end		
	end
end

--Creates button with UIPanelButtonTemplate2. Improve this.
local function CreateButton(name, parent, width, height, point, x, y, text)
	local button = CreateFrame('Button', name, parent, 'UIPanelButtonTemplate2');
	button:SetWidth(width); button:SetHeight(height);
	button:SetPoint(point, x, y);
	button:SetText(text);
	return button;
end

--Assigns random sounds to all tracks.
local function randomizeSounds()
	for i = 1, 8 do
		soundTable[i] = soundLibrary[math.random(#soundLibrary)]
		soundEditFrames[i]:SetText(soundTable[i]);
	end
end

--Function to handle enabling/disabling of the checkboxes.
local function updateBeatDisplay(oldvalue, value)
	if value < oldvalue then
		for i = 1, 8 do
			rhythmButtons[i]['button'][value + 1]:Disable();
		end
	else
		for i = 1, 8 do
			rhythmButtons[i]['button'][value]:Enable();
		end		
	end
end

--Main frame
local musicFrameContainer = CreateFrame('FRAME', 'Music_MainFrameContainer', UI_Parent);
musicFrameContainer:SetWidth(460); musicFrameContainer:SetHeight(500); 
musicFrameContainer:SetPoint('CENTER', 0, 0);
musicFrameContainer:SetBackdrop({
	bgFile='Interface/DialogFrame/UI-DialogBox-Background', 
	edgeFile='Interface/DialogFrame/UI-DialogBox-Border', 
	tile = true, tileSize = 32, edgeSize = 16,
	insets = { left = 5, right = 5, top = 5, bottom = 5 }})
musicFrameContainer:SetBackdropColor(0, 0, 0, 1);
musicFrameContainer:SetFrameStrata('HIGH');
musicFrameContainer:SetScript('OnMouseDown', musicFrameContainer.StartMoving);
musicFrameContainer:SetScript('OnMouseUp', musicFrameContainer.StopMovingOrSizing);
musicFrameContainer:EnableMouse(true);
musicFrameContainer:SetMovable(true);
musicFrameContainer:Hide();

--Graphic to hold title of main frame.
local musicFrameContainerHeader = musicFrameContainer:CreateTexture()
musicFrameContainerHeader:SetWidth(320); musicFrameContainerHeader:SetHeight(48);
musicFrameContainerHeader:SetPoint('TOP', 0, 12);
musicFrameContainerHeader:SetTexture('Interface/DialogFrame/UI-DialogBox-Header');

--Title of main frame.	
local musicFrameContainerHeaderText = musicFrameContainer:CreateFontString(nil,'ARTWORK','GameFontNormal');
musicFrameContainerHeaderText:SetText('Warcraft Music Maker');
musicFrameContainerHeaderText:SetPoint('TOP', 0, 3);
musicFrameContainerHeaderText:SetTextColor(1, 1, 0);

--Button to close main frame. Surely there's a template for this?	
local musicCloseButton = CreateFrame('BUTTON', 'music_CloseButton', Music_MainFrameContainer);
musicCloseButton:SetPoint('TOPRIGHT', 0, 0);
musicCloseButton:SetHeight(24); musicCloseButton:SetWidth(24);
musicCloseButton:SetHighlightTexture('Interface/BUTTONS/UI-Panel-MinimizeButton-Highlight');
musicCloseButton:SetNormalTexture('Interface/BUTTONS/UI-Panel-MinimizeButton-Up');
musicCloseButton:SetScript('OnClick', function(self) musicFrameContainer:Hide(); updateFrame:SetScript('OnUpdate', nil); end);
	
local startSoundButton = CreateButton('StartSound_Button', Music_MainFrameContainer, 50, 20, 'TOPLEFT', 170, -20, 'Start');
startSoundButton:SetScript('OnClick', function() if playStatus == 0 then playStatus = 1; startSoundButton:SetText('Stop'); else playStatus = 0; startSoundButton:SetText('Start'); end end);
local clearSoundButton = CreateButton('ClearSound_Button', Music_MainFrameContainer, 50, 20, 'TOPLEFT', 240, -20, 'Clear');
clearSoundButton:SetScript('OnClick', function() for i = 1, 8 do for ii = 1, 20 do playTable[i]['Sequence'][ii] = 0; rhythmButtons[i]['button'][ii]:SetChecked(false); end end end);
local randomSoundButton = CreateButton('RandomSound_Button', Music_MainFrameContainer, 120, 20, 'BOTTOMLEFT', 20, 6, 'Random Sounds');
randomSoundButton:SetScript('OnClick', function() randomizeSounds(); end);

--Slider to control speed.
local speedSlider = CreateFrame('Slider', 'Speed_Slider', Music_MainFrameContainer, 'OptionsSliderTemplate');
speedSlider:SetMinMaxValues(0.10, 0.50);
speedSlider:SetValueStep(0.01);
speedSlider:SetPoint('TOPRIGHT', -20, -20);
speedSlider:SetValue(0.10);
speedSlider:SetScript('OnValueChanged', function(self, value) speedSliderText:SetText(string.format('%.2f', speedSlider:GetValue())..'s'); playInterval = value end); 
getglobal(speedSlider:GetName() .. 'Low'):SetText('');
getglobal(speedSlider:GetName() .. 'High'):SetText(''); 
getglobal(speedSlider:GetName() .. 'Text'):SetText('Interval');
speedSliderText = speedSlider:CreateFontString(nil,'ARTWORK','GameFontHighlightSmall');
speedSliderText:SetPoint('CENTER', 0, -11);
speedSliderText:SetText(string.format('%.2f', speedSlider:GetValue())..'s');

--Slider to control amount of notes.
local beatSlider = CreateFrame('Slider', 'Beat_Slider', Music_MainFrameContainer, 'OptionsSliderTemplate');
beatSlider:SetMinMaxValues(2, 20);
beatSlider:SetValueStep(1);
beatSlider:SetPoint('TOPLEFT', 20, -20);
beatSlider:SetValue(20);
beatSlider:SetScript('OnValueChanged', function(self, value) beatSliderText:SetText(beatSlider:GetValue()); updateBeatDisplay(maxBeatNumber, value); maxBeatNumber = beatSlider:GetValue(); end); 
getglobal(beatSlider:GetName() .. 'Low'):SetText('');
getglobal(beatSlider:GetName() .. 'High'):SetText(''); 
getglobal(beatSlider:GetName() .. 'Text'):SetText('# Beats');
beatSliderText = beatSlider:CreateFontString(nil,'ARTWORK','GameFontHighlightSmall');
beatSliderText:SetPoint('CENTER', 0, -11);
beatSliderText:SetText(beatSlider:GetValue());
beatSlider:SetScript('OnEnter', function() GameTooltip:SetOwner(Beat_Slider, 'ANCHOR_TOPRIGHT'); GameTooltip:AddLine('Moving this slider too fast may cause a graphical glitch.'); GameTooltip:Show(); end);
beatSlider:SetScript('OnLeave', function() GameTooltip:Hide(); end);

--Frame to browse sounds.
local soundBrowser = CreateFrame('Frame', 'SoundBrowser_Frame', Music_MainFrameContainer);
soundBrowser:SetWidth(200); soundBrowser:SetHeight(300);
soundBrowser:SetPoint('BOTTOMRIGHT', 198, 0);
soundBrowser:SetBackdrop({ bgFile='Interface/DialogFrame/UI-DialogBox-Background', 
	edgeFile='Interface/DialogFrame/UI-DialogBox-Border', 
	tile = true, tileSize = 32, edgeSize = 16,
	insets = { left = 5, right = 5, top = 5, bottom = 5 }})
soundBrowser:SetBackdropColor(0, 0, 0, 1);
soundBrowser:EnableMouseWheel(1);
soundBrowser:Hide();

--Frame that shows selected sound.
local selectedSound =  CreateFrame('Frame', 'SoundBrowser_SelectedSound', SoundBrowser_Frame);
selectedSound:SetWidth(200); selectedSound:SetHeight(25);
selectedSound:SetPoint('TOP', 0, 18);
selectedSound:SetBackdrop({ bgFile='Interface/DialogFrame/UI-DialogBox-Background', 
	edgeFile='Interface/DialogFrame/UI-DialogBox-Border', 
	tile = true, tileSize = 32, edgeSize = 16,
	insets = { left = 5, right = 5, top = 5, bottom = 5 }})
selectedSound:SetBackdropColor(0, 0, 0, 1);
selectedSound:SetScript('OnEnter', function() GameTooltip:SetOwner(SoundBrowser_SelectedSound, 'ANCHOR_TOPRIGHT'); GameTooltip:AddLine('Your current selected sound.'); GameTooltip:Show(); end);
selectedSound:SetScript('OnLeave', function() GameTooltip:Hide(); end);
selectedSound:EnableMouse(true);

local selectedSoundText = selectedSound:CreateFontString(nil,'ARTWORK','GameFontNormal');
selectedSoundText:SetPoint('LEFT', 5, 0);
selectedSoundText:SetText('No Sound Selected!');

--Create sound browser contents.
for i = 1, 28 do
	soundFileButtons[i] = {}
	local soundFileButton = CreateFrame('Button', 'SoundBrowser_SoundButton'..i, SoundBrowser_Frame);
	soundFileButton:SetWidth(200); soundFileButton:SetHeight(15);
	soundFileButton:SetPoint('TOPLEFT', 7, i * -10 + 5);
	soundFileButton:RegisterForClicks('AnyUp');
	soundFileButtonText = soundFileButton:CreateFontString(nil, 'ARTWORK', 'GameTooltipTextSmall');
	soundFileButtonText:SetText(string.match(soundLibrary[i], matchPattern));
	soundFileButtonText:SetPoint('LEFT');
	soundFileButtons[i]['button'] = soundFileButton;
	soundFileButtons[i]['text'] = soundFileButtonText;
	soundFileButtons[i]['button']:SetScript('OnEnter', function() soundFileButtons[i]['text']:SetTextColor(1, 1, 0) end);
	soundFileButtons[i]['button']:SetScript('OnLeave', function() soundFileButtons[i]['text']:SetTextColor(1, 1, 1) end);
	soundFileButtons[i]['button']:SetScript('OnClick', function(self) PlaySoundFile(soundLibrary[i], "MASTER"); soundToSet = soundLibrary[i]; selectedSoundText:SetText(string.match(soundToSet, matchPattern)); end);
end

--This function is haunted. (Updates sound browsers when moving slider)
local function UpdateSoundBrowser(value)
	for i = 1, 28 do
		soundFileButtons[i]['button']:SetScript('OnClick', function(self) PlaySoundFile(soundLibrary[value + i - 1], "MASTER"); soundToSet = soundLibrary[value + i - 1]; selectedSoundText:SetText(string.match(soundToSet, matchPattern)); end);
		soundFileButtons[i]['text']:SetText(string.match(soundLibrary[value + i - 1], matchPattern));
	end
end

local soundBrowserSlider = CreateFrame('Slider', 'SoundBrowser_Slider', SoundBrowser_Frame);
soundBrowserSlider:SetMinMaxValues(1, #soundLibrary - 27);
soundBrowserSlider:SetValueStep(1);
soundBrowserSlider:SetPoint('RIGHT', 15, 0);
soundBrowserSlider:SetHitRectInsets(0, 0, 0, 0);
soundBrowserSlider:SetValue(1);
soundBrowserSlider:SetOrientation('VERTICAL');
soundBrowserSlider:SetHeight(270); soundBrowserSlider:SetWidth(10);
soundBrowserSlider:SetThumbTexture('Interface/Buttons/UI-ScrollBar-Knob') 
soundBrowserSlider:SetScript('OnValueChanged', function(self, value) UpdateSoundBrowser(value); end);
soundBrowser:SetScript('OnMouseWheel', function(self, direction) if direction == -1 then soundBrowserSlider:SetValue(soundBrowserSlider:GetValue() + 5) elseif direction == 1 then soundBrowserSlider:SetValue(soundBrowserSlider:GetValue() - 5) end end);

local soundBrowserSliderUp = CreateFrame('Button', 'SoundBrowser_UpButton', SoundBrowser_Slider);
soundBrowserSliderUp:SetWidth(30); soundBrowserSliderUp:SetHeight(30);
soundBrowserSliderUp:SetPoint('TOP', 0, 15);
soundBrowserSliderUp:SetNormalTexture('Interface/Buttons/UI-ScrollBar-ScrollUpButton-Up');
soundBrowserSliderUp:SetScript('OnClick', function() soundBrowserSlider:SetValue(soundBrowserSlider:GetValue() - 1) end);
	
local soundBrowserSliderDown = CreateFrame('Button', 'SoundBrowser_DownButton', SoundBrowser_Slider);
soundBrowserSliderDown:SetWidth(30); soundBrowserSliderDown:SetHeight(30);
soundBrowserSliderDown:SetPoint('BOTTOM', 0, -15);
soundBrowserSliderDown:SetNormalTexture('Interface/Buttons/UI-ScrollBar-ScrollDownButton-Up');
soundBrowserSliderDown:SetScript('OnClick', function() soundBrowserSlider:SetValue(soundBrowserSlider:GetValue() + 1) end);

local soundBrowserButton = CreateFrame('BUTTON', 'SoundBrowser_Button', Music_MainFrameContainer, 'UIPanelButtonTemplate2'); 
soundBrowserButton:SetPoint('BOTTOMRIGHT', -20, 6); 
soundBrowserButton:SetWidth(120);
soundBrowserButton:SetHeight(20);
soundBrowserButton:SetText('Sound Library');
soundBrowserButton:SetScript('OnClick', function(self) if not soundBrowser:IsShown() then soundBrowser:Show(); soundBrowserButton:LockHighlight() else soundBrowser:Hide(); soundBrowserButton:UnlockHighlight() end; end);

--Function to create tracks.
local function createTrack(id, trackX, trackY)
	--Create frame to hold track contents.
	local trackFrame = CreateFrame('FRAME', 'trackFrame'..id, musicFrameContainer);
	trackFrame:SetWidth(200); trackFrame:SetHeight(100);
	trackFrame:SetPoint('TOPLEFT', trackX, trackY);
	trackFrame:SetBackdrop({
	bgFile='Interface/DialogFrame/UI-DialogBox-Background', 
	edgeFile='Interface/Tooltips/UI-Tooltip-Border', 
	tile = true, tileSize = 32, edgeSize = 16,
	insets = { left = 5, right = 5, top = 5, bottom = 5 }})
	trackFrame:SetBackdropColor(0, 0, 0, 0);
	--Track nr
	local trackNumber = trackFrame:CreateFontString(nil,'ARTWORK','GameFontNormal');
	trackNumber:SetText('Track '..id);
	trackNumber:SetPoint('TOPLEFT', 10, -15);
	trackNumber:SetTextColor(0, 1, 0);
	--Mute button
	local muteButton = CreateButton('Mute_Button'..id, trackFrame, 45, 20, 'TOPLEFT', 150, -10, 'Mute');
	muteButton:SetScript('OnClick', function() if playTable[id]['Muted'] == 0 then playTable[id]['Muted'] = 1; muteButton:LockHighlight(); trackNumber:SetTextColor(1, 0, 0); else playTable[id]['Muted'] = 0; muteButton:UnlockHighlight(); trackNumber:SetTextColor(0, 1, 0); end end);
	--Create editbox that holds soundfile.
	local soundEditBox = CreateFrame('EditBox', 'SoundFile_EditBox'..id, trackFrame, 'InputBoxTemplate');
	soundEditBox:SetPoint('TOPLEFT', 13, -35);
	soundEditBox:SetWidth(150); soundEditBox:SetHeight(15);
	soundEditBox:SetText(soundTable[id]);
	soundEditBox:SetAutoFocus(false);
	soundEditFrames[id] = soundEditBox;
	--Create button to set new soundfile.
	local setSoundButton = CreateButton('SetSound_Button'..id, trackFrame, 30, 20, 'TOPLEFT', 165, -33, 'Set');
	setSoundButton:SetScript('OnClick', function(self) soundTable[id] = soundToSet; soundEditFrames[id]:SetText(soundToSet); end);
	--Create boxes to set rhythm. 
	local rhythmX, rhythmY, incX = 6, -56, 0
	rhythmButtons[id] = {}
	rhythmButtons[id]['tex'] = {}
	rhythmButtons[id]['button'] = {}
	for i = 1, 20 do
		local rhythmButton = CreateFrame('CheckButton', 'Rhythm_Button'..i, trackFrame, 'ChatConfigCheckButtonTemplate');
		rhythmButton:SetPoint('TOPLEFT', rhythmX + incX, rhythmY);
		rhythmButton:SetHitRectInsets(0, 0, 0, 0);
		rhythmButton:SetDisabledTexture('Interface/Buttons/UI-Panel-MinimizeButton-Disabled');
		rhythmButton:SetDisabledCheckedTexture('Interface/Buttons/UI-Panel-MinimizeButton-Disabled');
		rhythmButtonTex = rhythmButton:CreateTexture();
		rhythmButtonTex:SetTexture(0, 1, 0, 0.0);
		rhythmButtonTex:SetWidth(12); rhythmButtonTex:SetHeight(12);
		rhythmButtonTex:SetPoint('CENTER')
		rhythmButtons[id]['tex'][i] = rhythmButtonTex;
		rhythmButtons[id]['button'][i] = rhythmButton;
		rhythmButton:SetScript('OnClick', function(self) if rhythmButton:GetChecked() == 1 then playTable[id]['Sequence'][i] = 1; else playTable[id]['Sequence'][i] = 0; end; end);
		incX = incX + 18;
		if i == 10 then rhythmX, rhythmY, incX = 6, -73, 0 end;
	end
end

--Create Tracks
local trackX, trackY = 20, -45
for i = 1, 8 do
	createTrack(i, trackX, trackY);
	trackX = trackX + 220
	if i == 2 or i == 4 or i == 6 then trackX, trackY = 20, trackY - 110; end;
end

SLASH_WMM1 = '/wmm';
SlashCmdList['WMM'] = function() musicFrameContainer:Show(); updateFrame:SetScript('OnUpdate', Music_OnUpdate); end