--[[
    Armory Addon for World of Warcraft(tm).
    Revision: 420 2011-04-05T08:32:09Z
    URL: http://www.wow-neighbours.com

    License:
        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program(see GPL.txt); if not, write to the Free Software
        Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Note:
        This AddOn's source code is specifically designed to work with
        World of Warcraft's interpreted AddOn system.
        You have an implicit licence to use this AddOn with these facilities
        since that is it's designated purpose as per:
        http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
--]]
 
local Armory = Armory;

ARMORY_PETSTAT_DROPDOWN_OPTIONS = {
    "GENERAL",
    "MELEE",
    "SPELL",
    "DEFENSE",
};

local STRIPE_COLOR = {r=0.9, g=0.9, b=1};


function ArmoryPetPaperDollFrame_OnLoad(self)
    self:RegisterEvent("UNIT_PET_EXPERIENCE");
    self:RegisterEvent("UNIT_MODEL_CHANGED");
    self:RegisterEvent("UNIT_LEVEL");
    self:RegisterEvent("UNIT_RESISTANCES");
    self:RegisterEvent("UNIT_STATS");
    self:RegisterEvent("UNIT_DAMAGE");
    self:RegisterEvent("UNIT_RANGEDDAMAGE");
    self:RegisterEvent("UNIT_ATTACK_SPEED");
    self:RegisterEvent("UNIT_ATTACK_POWER");
    self:RegisterEvent("UNIT_RANGED_ATTACK_POWER");
    self:RegisterEvent("UNIT_DEFENSE");
    self:RegisterEvent("UNIT_ATTACK");
    self:RegisterEvent("PET_SPELL_POWER_UPDATE");
end

function ArmoryPetPaperDollFrame_OnEvent(self, event, ...)
    local arg1, arg2 = ...;
    if ( not Armory:CanHandleEvents() ) then
        return;
    elseif ( event == "UNIT_PET_EXPERIENCE" ) then
        Armory:Execute(ArmoryPetPaperDollFrame_SetLevel);
    elseif( event == "PET_SPELL_POWER_UPDATE" ) then
        Armory:Execute(ArmoryPetPaperDollFrame_Update);
    elseif ( arg1 == "pet" ) then
        Armory:Execute(ArmoryPetPaperDollFrame_Update);
    end
end

function ArmoryPetStatFrameDropDown_OnLoad(self)
    ArmoryDropDownMenu_Initialize(self, ArmoryPetStatFrameDropDown_Initialize);
    ArmoryDropDownMenu_SetSelectedValue(self, ARMORY_PETSTAT_DROPDOWN_SELECTION);
    ArmoryDropDownMenu_SetWidth(self, 214);
    ArmoryDropDownMenu_JustifyText(self, "LEFT");
end

function ArmoryPetStatFrameDropDown_Initialize()
    -- Setup buttons
    local info = ArmoryDropDownMenu_CreateInfo();
    local checked;
    for i = 1, getn(ARMORY_PETSTAT_DROPDOWN_OPTIONS) do
        if ( ARMORY_PETSTAT_DROPDOWN_OPTIONS[i] == ARMORY_PETSTAT_DROPDOWN_SELECTION ) then
            checked = 1;
        else
            checked = nil;
        end
        info.text = _G["STAT_CATEGORY_"..ARMORY_PETSTAT_DROPDOWN_OPTIONS[i]];
        info.func = ArmoryPetStatFrameDropDown_OnClick;
        info.value = ARMORY_PETSTAT_DROPDOWN_OPTIONS[i];
        info.checked = checked;
        info.owner = ARMORY_DROPDOWNMENU_OPEN_MENU;
        ArmoryDropDownMenu_AddButton(info);
    end
end

function ArmoryPetStatFrameDropDown_OnClick(self)
    ArmoryDropDownMenu_SetSelectedValue(_G[self.owner], self.value);
    ARMORY_PETSTAT_DROPDOWN_SELECTION = self.value;
    ArmoryPetPaperDollFrame_UpdateStatCategory(self.value);
end

function ArmoryPetPaperDollFrame_UpdateStatCategory(category)
    local categoryInfo = PAPERDOLL_STATCATEGORIES[category];
    
    local numVisible = 0;
    for index, stat in next, categoryInfo.stats do
        local statInfo = ARMORY_PAPERDOLL_STATINFO[stat];
        local statFrame = _G["ArmoryPetStatFrame"..numVisible+1];
        statFrame:Show();
        -- Reset tooltip script in case it's been changed
        statFrame:SetScript("OnEnter", PaperDollStatTooltip);
        statFrame.tooltip = nil;
        statFrame.tooltip2 = nil;
        statFrame.UpdateTooltip = nil;
        statFrame:SetScript("OnUpdate", nil);
        statInfo.updateFunc(statFrame, "pet");
        if ( statFrame:IsShown() ) then
            numVisible = numVisible + 1;
            -- Update Tooltip
            if ( GameTooltip:GetOwner() == statFrame ) then
                statFrame:GetScript("OnEnter")(statFrame);
            end
        end
    end
    
    local index = 1;
    while ( _G["ArmoryPetStatFrame"..index] ) do
        local statFrame = _G["ArmoryPetStatFrame"..index];
        if ( index <= numVisible ) then
            if ( not statFrame.Bg ) then
                statFrame.Bg = statFrame:CreateTexture(statFrame:GetName().."Bg", "BACKGROUND");
                statFrame.Bg:SetPoint("LEFT", "ArmoryPetAttributesFrame", "LEFT", 2, 0);
                statFrame.Bg:SetPoint("RIGHT", "ArmoryPetAttributesFrame", "RIGHT", -2, 0);
                statFrame.Bg:SetPoint("TOP");
                statFrame.Bg:SetPoint("BOTTOM");
                statFrame.Bg:SetTexture(STRIPE_COLOR.r, STRIPE_COLOR.g, STRIPE_COLOR.b);
                statFrame.Bg:SetAlpha(0.1);
            end
            if ( index % 2 == 0 ) then
                statFrame.Bg:Show();
            else
                statFrame.Bg:Hide();
            end
        else
            statFrame:Hide();
        end
        index = index + 1;
    end
end

function ArmoryPetPaperDollFrame_ResetStatDropDown()
    ARMORY_PETSTAT_DROPDOWN_SELECTION = ARMORY_PETSTAT_DROPDOWN_SELECTION or "MELEE";
    ArmoryDropDownMenu_SetSelectedValue(ArmoryPetStatFrameDropDown, ARMORY_PETSTAT_DROPDOWN_SELECTION);
    ArmoryPetPaperDollFrame_UpdateStatCategory(ARMORY_PETSTAT_DROPDOWN_SELECTION);    
end

function ArmoryPetPaperDollFrame_Update()
    ArmoryPetPaperDollFrame_ResetStatDropDown();
    ArmoryBuffFrame_Update("pet");
    ArmoryPetPaperDollFrame_SetLevel();
    ArmoryPetPaperDollFrame_SetResistances();

    local _, canGainXP = Armory:HasPetUI();
    if ( canGainXP ) then
        ArmoryPetPaperDollPetInfo:Show();
        ArmoryPetDietText:SetText(format(PET_DIET_TEMPLATE, BuildListString(Armory:GetPetFoodTypes()) or "?"));
    else
        ArmoryPetPaperDollPetInfo:Hide();
    end
end

function ArmoryPetPaperDollFrame_SetLevel()
    local currXP, nextXP = Armory:GetPetExperience();
    local text = "";
    if ( Armory:UnitCreatureFamily("pet") ) then
        text = format(UNIT_TYPE_LEVEL_TEMPLATE, Armory:UnitLevel("pet"), Armory:UnitCreatureFamily("pet"));
    end
    if ( (nextXP or 0) > 0 ) then
        local percentXP = floor((currXP * 100) / nextXP);
        if ( percentXP > 0 ) then
            text = text.." ("..XP.." "..percentXP.."%)";
        end
    end
    ArmoryPetLevelText:SetText(text);
end

function ArmoryPetPaperDollFrame_SetResistances()
    for i = 1, NUM_PET_RESISTANCE_TYPES, 1 do
        local frame = _G["ArmoryPetMagicResFrame"..i];
        ArmoryPaperDollFrame_SetResistance(frame, "pet", frame:GetID());
    end
end
