--[[
    Armory Addon for World of Warcraft(tm).
    Revision: 437 2011-10-26T16:01:08Z
    URL: http://www.wow-neighbours.com

    License:
        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program(see GPL.txt); if not, write to the Free Software
        Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Note:
        This AddOn's source code is specifically designed to work with
        World of Warcraft's interpreted AddOn system.
        You have an implicit licence to use this AddOn with these facilities
        since that is it's designated purpose as per:
        http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
--]] 

local Armory = Armory;

ARMORY_GLYPH_TYPE_MAJOR = 1;
ARMORY_GLYPH_TYPE_MINOR = 2;
ARMORY_GLYPH_TYPE_PRIME = 3;

ARMORY_NUM_GLYPH_SLOTS = 9;

ARMORY_GLYPH_TYPE_INFO = {};
ARMORY_GLYPH_TYPE_INFO[ARMORY_GLYPH_TYPE_PRIME] =  {
    ring = { size = 62, left = 0.85839844, right = 0.93847656, top = 0.22265625, bottom = 0.30273438 };
    highlight = { size = 72, left = 0.85839844, right = 0.95214844, top = 0.30468750, bottom = 0.39843750 };
}
ARMORY_GLYPH_TYPE_INFO[ARMORY_GLYPH_TYPE_MAJOR] =  {
    ring = { size = 50, left = 0.85839844, right = 0.92285156, top = 0.00097656, bottom = 0.06542969 };
    highlight = { size = 60, left = 0.85839844, right = 0.93652344, top = 0.06738281, bottom = 0.14550781 };
}
ARMORY_GLYPH_TYPE_INFO[ARMORY_GLYPH_TYPE_MINOR] =  {
    ring = { size = 46, left = 0.92480469, right = 0.98437500, top = 0.00097656, bottom = 0.06054688 };
    highlight = { size = 56, left = 0.85839844, right = 0.93164063, top = 0.14746094, bottom = 0.22070313 };
}


function ArmoryGlyphFrameGlyph_OnLoad(self)
    self.glyphType = nil;
end

function ArmoryGlyphFrameGlyph_UpdateSlot(self)
    local id = self:GetID();
    local enabled, glyphType, glyphTooltipIndex, glyphSpell, iconFilename = Armory:GetGlyphSocketInfo(id, ArmoryTalentFrame.talentGroup);
    if ( not glyphType ) then
        self:Hide();
        return;
    end

    ArmoryGlyphFrameGlyph_SetGlyphType(self, glyphType);

    if ( not enabled ) then
        self:Hide();
    elseif ( not glyphSpell ) then
        self.spell = nil;
        self.glyph:SetTexture("");
        self:Show();
    else
        self.spell = glyphSpell;
        self.glyph:Show();
        if ( iconFilename ) then
            SetPortraitToTexture(self.glyph, iconFilename);
        else
            self.glyph:SetTexture("Interface\\Spellbook\\UI-Glyph-Rune1");
        end
        self:Show();
    end
end

function ArmoryGlyphFrameGlyph_SetGlyphType(glyph, glyphType)
    local info = ARMORY_GLYPH_TYPE_INFO[glyphType];
    if info then
        glyph.glyphType = glyphType;

        glyph.ring:SetWidth(info.ring.size);
        glyph.ring:SetHeight(info.ring.size);
        glyph.ring:SetTexCoord(info.ring.left, info.ring.right, info.ring.top, info.ring.bottom);

        glyph.glyph:SetWidth(info.ring.size - 4);
        glyph.glyph:SetHeight(info.ring.size - 4);
        glyph.glyph:SetAlpha(0.75);
    end
end

function ArmoryGlyphFrameGlyph_OnClick(self, button)
    if ( IsModifiedClick("CHATLINK") and ChatEdit_GetActiveWindow() ) then
        local link = Armory:GetGlyphLink(self:GetID(), ArmoryTalentFrame.talentGroup);
        if ( link ) then
	        ChatEdit_InsertLink(link);
        end
    end
end

function ArmoryGlyphFrameGlyph_OnEnter(self)
    GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
    Armory:SetGlyph(self:GetID(), ArmoryTalentFrame.talentGroup);
    GameTooltip:Show();
end

function ArmoryGlyphFrameGlyph_OnLeave(self)
    GameTooltip:Hide();
end

function ArmoryGlyphFrame_OnShow(self)
    local isActiveTalentGroup = ArmoryTalentFrame.talentGroup == Armory:GetActiveTalentGroup();
    SetDesaturation(ArmoryGlyphFrameBackground, not isActiveTalentGroup);

    -- set the title text of the GlyphFrame
    if ( Armory:GetNumTalentGroups() > 1 ) then
        if ( ArmoryTalentFrame.talentGroup == 1 ) then
            ArmoryGlyphFrameTitleText:SetText(TALENT_SPEC_PRIMARY_GLYPH);
        else
            ArmoryGlyphFrameTitleText:SetText(TALENT_SPEC_SECONDARY_GLYPH);
        end
    else
        ArmoryGlyphFrameTitleText:SetText(GLYPHS);
    end

    for i = 1, ARMORY_NUM_GLYPH_SLOTS do
        ArmoryGlyphFrameGlyph_UpdateSlot(_G["ArmoryGlyphFrameGlyph" .. i]);
    end
end

function ArmoryGlyphFrame_OnLoad(self)
    self:RegisterEvent("PLAYER_ENTERING_WORLD");
    self:RegisterEvent("GLYPH_ADDED");
    self:RegisterEvent("GLYPH_REMOVED");
    self:RegisterEvent("GLYPH_UPDATED");
    self:RegisterEvent("USE_GLYPH");
    self:RegisterEvent("PLAYER_LEVEL_UP");
end

function ArmoryGlyphFrame_OnEvent(self, event, ...)
    if ( not Armory:CanHandleEvents() ) then
        return;
    elseif ( event == "PLAYER_ENTERING_WORLD" ) then
        self:UnregisterEvent("PLAYER_ENTERING_WORLD");
        if ( Armory.forceScan or not Armory:GlyphsExists() ) then
            Armory:Execute(ArmoryGlyphFrame_Update);
        end
    else
        Armory:Execute(ArmoryGlyphFrame_Update);
    end
end

function ArmoryGlyphFrame_Update()
    Armory:UpdateGlyphs();
    ArmoryGlyphFrame_OnShow(ArmoryGlyphFrame);
end