-------------------------------------------------------------------------------
-- Broker: SmartAuraWatch
-- Created by Aeldra (EU-Proudmoore)
--
-- Data Broker support
-------------------------------------------------------------------------------

local t = "SmartAuraWatch";
local f = CreateFrame("Frame", "Broker_"..t);

local function ShowMenu()
	if (not f.Menu) then
		f.Menu = CreateFrame("Frame", "Broker_SmartAuraWatch_Menu");
	end
	local menu = f.Menu;
	menu.displayMode = "MENU";
	
	local info = {};
	menu.initialize = function(self, level)
	  local O = SmartAuraWatch_Options;
	  local L = SmartAuraWatchLoc;
	  if (not O or not L or not level) then return end
	  wipe(info);
	  if (level == 1) then
	    -- Create the title of the menu
	    info.isTitle = true;
	    info.text = t;
	    info.notCheckable = true;
	    UIDropDownMenu_AddButton(info, level);

      -- Direct access to all bars statistics
      for i = 1, O.Bars do
		    wipe(info);
		    info.text = format(L.StatBar, i);
		    info.notCheckable = true;
		    info.func = function(self) SmartAuraWatch_ShowStatList(i) end
		    UIDropDownMenu_AddButton(info, level);
		  end
		  
		  -- Statistics reset
		  wipe(info);
		  info.text = L.StatResetAll;
		  info.notCheckable = true;
		  info.func = function(self) SmartAuraWatch_ProcessStatAutoReset(true) end
		  UIDropDownMenu_AddButton(info, level);		  
		  
		  -- Open options frame
		  wipe(info);
		  info.text = GAMEOPTIONS_MENU;
		  info.notCheckable = true;
		  info.func = function(self) SmartAuraWatchOptionsFrame:Show() end
		  UIDropDownMenu_AddButton(info, level);
		  
		  -- Blank separator
		  wipe(info);
		  info.disabled = true;
		  info.notCheckable = true;
		  UIDropDownMenu_AddButton(info, level);
		  
	    -- Close menu item
	    wipe(info);
	    info.text = CLOSE;
	    info.func = function() CloseDropDownMenus() end
	    info.checked = nil;
	    info.notCheckable = true;
	    UIDropDownMenu_AddButton(info, level);
    end
  end
  
  local x, y = GetCursorPosition(UIParent);
  local sc = UIParent:GetEffectiveScale();
  ToggleDropDownMenu(1, nil, menu, "UIParent", x/sc, y/sc);
end


local function OnClick(self, button)
  if (button == "RightButton") then
    SmartAuraWatchOptionsFrame:Show();
  elseif (button == "LeftButton" and (IsShiftKeyDown() or IsAltKeyDown())) then
    SmartAuraWatch_ShowStatList(1);
  elseif (button == "LeftButton") then
    ShowMenu();
  end
end


local function OnTooltipShow(self)
	if (not self or not self.AddLine) then return end
	--self:AddLine("|cffffffff"..t.."|r");
	--self:AddLine("Tooltip Info");
end


f.LS = LibStub:GetLibrary("LibDataBroker-1.1"):NewDataObject("BrokerSmartAuraWatch", {
	type = "launcher",
	label = t,
	icon = "Interface\\Icons\\inv_trinket_naxxramas02",
	OnClick = OnClick,
	OnTooltipShow = OnTooltipShow,
});

f:Hide();
print("Broker - SmartAuraWatch loaded");
