--[[
Bison - a framework for free positioning of buffs.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:
	
Free Software Foundation, I.,
51 Franklin Street, Fifth Floor,
Boston, MA  02110-1301, USA.
--]]

local MAJOR = 'prog'

local Addon  = LibStub( 'AceAddon-3.0'):GetAddon( 'Bison')
local L      = LibStub( 'AceLocale-3.0'):GetLocale( 'Bison')
local AceGUI = LibStub( 'AceGUI-3.0')

local NOTHING = {}
local UPDATE_TIME = 0.2
local MAX_BUTTON  = 16
local FILTER      = 'HELPFUL'
local PROGTABLES = {
	['DEATHKNIGHT'] = {
		[51124] = true, --Killing Machine
		[59052] = true, --Freezing Fog
		[81340] = true, --Sudden Doom
	},
	['DRUID'] = {
		[16870] = true, --Clearcasting
		[16886] = true, --Nature's Grace
		[22842] = true, --Frenzied Regen
		[48391] = true, --Owlkin Frenzy
		[48517] = true, --Eclipse (Solar)
		[48518] = true, --Eclipse (Lunar)
		[61336] = true, --Survival Instincts
		[69369] = true, --Predator's Swiftness
	},
	['HUNTER'] = {
		[ 3045] = true, --Rapid Fire
		[35098] = true, --Rapid Killing Rank 1
		[35099] = true, --Rapid Killing Rank 2
		[53220] = true, --Improved Steady Shot
		[56453] = true, --Lock and Load
		[64418] = true, --Sniper Training Rank 1
		[64419] = true, --Sniper Training Rank 2
		[64420] = true, --Sniper Training Rank 3
	},
	['MAGE'] = {
		[12042] = true, --Arcane Power
		[12472] = true, --Icy Veins
		[12536] = true, --Clearcasting
		[31643] = true, --Blazing Speed
		[36032] = true, --Arcane Blast
		[44544] = true, --Fingers of Frost
		[48108] = true, --Hot Streak
		[54741] = true, --Firestarter
		[57761] = true, --Brain Freeze
		[64343] = true, --Impact
	},
	['PALADIN'] = {
		[53672] = true, --Infusion of Light Rank 1
		[54149] = true, --Infusion of Light Rank 2
		[59578] = true, --Art of War
		[88819] = true, --Daybreak
		[90174] = true, --Hand of Light
	},
	['PRIEST'] = {
		[14751] = true, --Chakra
		[33151] = true, --Surge of Light
		[59887] = true, --Borrowed Time Rank 1
		[59888] = true, --Borrowed Time Rank 2
		[59889] = true, --Borrowed Time Rank 3
		[60062] = true, --Essence of Life
		[63731] = true, --Serendipity Rank 1
		[63735] = true, --Serendipity Rank 2
		[77487] = true, --Shadow Orb
		[81206] = true, --Chakra: Prayer of Healing
		[81207] = true, --Chakra: Renew
		[81208] = true, --Chakra: Heal
		[81292] = true, --Mind Melt
		[81660] = true, --Evangelism Rank 1
		[81661] = true, --Evangelism Rank 2
		[87117] = true, --Dark Evangelism Rank 1
		[87118] = true, --Dark Evangelism Rank 2
		[87152] = true, --Archangel
		[87153] = true, --Dark Archangel
		[88688] = true, --Surge of Light
	},
	['ROGUE'] = {
		[13750] = true, --Adrenline Rush
		[13877] = true, --Blade Flurry
		[14251] = true, --Riposte
		[51713] = true, --Shadow Dance
	},
	['SHAMAN'] = {
		[16246] = true, --Clearcasting
		[53390] = true, --Tital Waves
		[53817] = true, --Maelstrom Weapon
		[55198] = true, --Tidal Force
		[64701] = true, --Elemental Mastery
	},
	['WARLOCK'] = {
		[17941] = true, --Nightfall
		[34936] = true, --Backlash
		[47283] = true, --Empowered Imp
		[47383] = true, --Molten Core Rank 1
		[54274] = true, --Backdraft Rank 1
		[54276] = true, --Backdraft Rank 2
		[54277] = true, --Backdraft Rank 3
		[63165] = true, --Decimation Rank 1
		[63167] = true, --Decimation Rank 2
		[64368] = true, --Eradication Rank 1
		[64370] = true, --Eradication Rank 2
		[64371] = true, --Eradication Rank 3
		[71162] = true, --Molten Core Rank 2
		[71165] = true, --Molten Core Rank 3
	},
	['WARRIOR'] = {
		[12975] = true, --Last Stand
		[46916] = true, --Bloodsurge
		[50227] = true, --Sword and Board
		[52437] = true, --Sudden Death
		[60503] = true, --Taste for Blood
		[87095] = true, --Thunderstruck Rank 1
		[87096] = true, --Thunderstruck Rank 2
	},
}

local Module = Addon:NewBarModule( MAJOR)
Module.filter  = FILTER
Module.color   = { r=0.2, g=0.4, b=0.2 }
Module.proName = 'prog'

local progTable = NOTHING
local args = {
	option = { 
		type = 'group', order = 10, name = L.OptionName, inline = true, 
		args = {
			show     = { type = 'toggle', order = 10, name = L.ShowName,     desc = L.ShowDesc, width = 'full' },
			sort     = { type = 'select', order = 20, name = L.SortName,     desc = L.SortDesc, get = 'GetSortType', set = 'SetSortType', values = 'GetSortDesc' },
			timer    = { type = 'select', order = 30, name = L.TimerName,    desc = L.TimerDesc, values = 'GetTimerDesc' },
			flashing = { type = 'toggle', order = 40, name = L.FlashingName, desc = L.FlashingDesc },
			spell    = { type = 'toggle', order = 50, name = L.SpellName,    desc = L.SpellDesc },
		} 
	},
	layout = { 
		type = 'group', order = 20, name = L.BarName, inline = true, 
		args = {
			horizontal = { type = 'toggle', order = 10, name = L.HorizontalName, desc = L.HorizontalDesc, width = 'full' },
			number     = { type = 'range',  order = 30, name = L.NumberName,     desc = L.NumberDesc,   set = 'SetNumber',   min = 1,    max = MAX_BUTTON, step = 1 },
			scale      = { type = 'range',  order = 40, name = L.ScaleName,      desc = L.ScaleDesc,    set = 'SetScale',    min = 0.01, max = 2,          step = 0.01, isPercent = true },
			cols       = { type = 'range',  order = 50, name = L.ColsName,       desc = L.ColsDesc,     set = 'SetCols',     min = 1,    max = MAX_BUTTON, step = 1 },
			xPadding   = { type = 'range',  order = 60, name = L.XPaddingName,   desc = L.XPaddingDesc, set = 'SetXPadding', min = -20,  max = 20,         step = 1 },
			rows       = { type = 'range',  order = 70, name = L.RowsName,       desc = L.RowsDesc,     set = 'SetRows',     min = 1,    max = MAX_BUTTON, step = 1 },
			yPadding   = { type = 'range',  order = 80, name = L.YPaddingName,   desc = L.YPaddingDesc, set = 'SetYPadding', min = -50,  max = 50,         step = 1 },
--			cooldown   = { type = 'toggle', order = 15, name = L.CooldownName,   desc = L.CooldownDesc },
		} 
	}
}
local blizzOptions = {
	type = 'group', order = 50, name = L.DescProgs, handler = Module, get = 'GetProperty', set = 'SetProperty', args = args
}
local dialogOptions = {
	type = 'group', order = 20, name = L.BarProg, handler = Module, get = 'GetProperty', set = 'SetProperty', args = args,
	plugins = {
		p1 = { 
			descr = { type = 'description', order = 5, name = L.DescProgs, fontSize = 'large' }
		}
	}
}

------------------------------------------------------------------------------------
-- Main
------------------------------------------------------------------------------------
function Module:OnModuleInitialize()
	self:RegisterOptions( blizzOptions, L.BarProg)
	self:CloneAura( 'buff')
	local _, class = UnitClass( 'player')
	progTable = PROGTABLES[class] or NOTHING
end

function Module:GetOptionTable()
	return dialogOptions
end

function Module:UpdateAnchors()
	Addon:Debug( 'UpdateAnchors', self:GetName())
	if self.profile.show then
		self:SortAura()
		local spell = self.profile.spell
		for i,a in pairs( self.aura) do
			local buff = self:GetUserBuff( 'BuffProgButton', a.id)
			self:UpdateLBF( buff)
			local child = self.group.children[i]
			if child and progTable[a.spellID] then
				self:UpdateUserBuff( buff, a)
				child:SetBuff( buff)
				child:SetSpell( spell and a.spellID)
			elseif child then
				self:HideUserBuff( buff)
				child:SetBuff( nil)
				child:SetSpell( nil)
			else
				self:HideUserBuff( buff)
			end
			self:UpdateBuffScale( buff)
		end
	end
end

function Module:UpdateAnchorsOld()
	Addon:Debug( 'UpdateAnchors', self:GetName())
	if self.profile.show then
		self:SortAura()
		local spell = self.profile.spell
		for i,child in pairs( self.group.children) do
			local a = self.aura[i]
			local buff = self:GetUserBuff( 'BuffProgButton', a.id)
			self:UpdateLBF( buff)
			if progTable[a.spellID] then
				self:UpdateUserBuff( buff, a)
				child:SetBuff( buff)
				child:SetSpell( spell and a.spellID)
			else
				self:HideUserBuff( buff)
				child:SetBuff( nil)
				child:SetSpell( nil)
			end
			self:UpdateBuffScale( buff)
		end
	end
end

function Module:UpdateBuffAnchors()
	self:UpdateAnchors()
end

function Module:MoveTo( offset)
	for i,child in pairs( self.group.children) do
		child:SetBuff( nil)
	end
	for id = 1,#self.aura do
		local buff = self:GetUserBuff( 'BuffProgButton', id)
		buff:Hide()
		buff.duration:Hide()
		buff:SetScript( 'OnUpdate', nil)
		buff.timeLeft = nil
	end
end

function Module:AdditionalSort( orig)
	return function( a, b) 
		local progA = a.spellID and progTable[a.spellID] or false
		local progB = b.spellID and progTable[b.spellID] or false
		if progA == progB then
			return orig( a, b)
		end
		return progA
	end
end
