local HomingDigeon = CreateFrame("FRAME", "HomingDigeon")

local x1, x2, y1, y2 = WorldMap_GetPOITextureCoords(177)
local digSites = {}
-- Turns out every flightmap and atlas map for each continent have differing
-- ratios between them. So magic numbers ahoy
-- [1] - Kalimdor
-- [2] - Eastern Kingdoms
-- [3] - Outlands
-- [4] - Northrend
local MagicXRatio = { [4] = 1.2, [3] = 1.3, [2] = 1.3, [1] = 1.5 }
local MagicYRatio = { [4] = 0.8, [3] = 1, [2] = 1, [1] = 1}
local MagicYOffset = { [4] = -30, [3] = 5, [2] = -5, [1] = -5}
local MagicXOffset = { [4] = 15, [3] = 0, [2] = 0, [1] = 0 }

local function ShowSites()
	
	for d,b in pairs(digSites) do
		d:Hide()
	end

	local storemap = GetCurrentMapAreaID()
   SetMapToCurrentZone()
   SetMapZoom(GetCurrentMapContinent())
   
				 local taxi_x = TAXI_MAP_WIDTH
				 local taxi_y = TAXI_MAP_HEIGHT
				 
				 local taxi_x_centre = taxi_x / 2
				 local taxi_y_centre = taxi_y / 2
				 
				 local world_x = WorldMapButton:GetWidth()
				 local world_y = WorldMapButton:GetHeight()

				 local world_x_centre = world_x / 2
				 local world_y_centre = world_y / 2

   for a=1,GetNumMapLandmarks() do
      local name, desc, tex, x, y = GetMapLandmarkInfo(a)
      if tex == 177 then
         local poiName = "WorldMapFramePOIDigSite"..a
         if not _G[poiName] then
            WorldMap_CreatePOI("DigSite"..a)
         end
         
         local worldMapPOI = _G[poiName]
				 
				 digSites[worldMapPOI] = true;

				 worldMapPOI.description = name
				 worldMapPOI:SetScript("OnEnter", 
						function() 
							GameTooltip:SetOwner(worldMapPOI, "ANCHOR_RIGHT"); 
							GameTooltip:AddLine(name, "", 1.0, 1.0, 1.0)
							GameTooltip:Show()
						end)
					worldMapPOI:SetScript("OnLeave",
						function()
							GameTooltip:Hide()
						end)
         worldMapPOI:SetParent(TaxiFrame)
         _G[poiName.."Texture"]:SetTexCoord(x1, x2, y1, y2)

				 tx = x * world_x 
         tx = taxi_x_centre - ((world_x_centre - tx) * (taxi_x/world_x) * MagicXRatio[GetCurrentMapContinent()]) + MagicXOffset[GetCurrentMapContinent()]
				 ty = y * world_y
				 ty = - taxi_y_centre + ((world_y_centre - ty) * (taxi_y/world_y) * MagicYRatio[GetCurrentMapContinent()]) - MagicYOffset[GetCurrentMapContinent()]
				 worldMapPOI:SetScale(1)
         worldMapPOI:SetPoint("CENTER", "TaxiRouteMap", "TOPLEFT", tx, ty)
         worldMapPOI:Show()
				 local min
				 local minode

         for i = 1,NumTaxiNodes() do
            local node = _G["TaxiButton"..i]
						node.x, node.y = TaxiNodePosition(node:GetID())
						local dx = math.abs(tx/taxi_x  - node.x)
						local dy = math.abs(math.abs(ty/taxi_y) - (1 - node.y))
						local dis = dx*dx + dy*dy
						if not min or dis < min then 
							min = dis 
							minode = node
						end						
         end
				if minode then
				 minode:SetNormalTexture(TaxiButtonTypes["DISTANT"].file)
			 end
				 --]]
      end
   end
   SetMapByID(storemap)
end

HomingDigeon:RegisterEvent("TAXIMAP_OPENED")
HomingDigeon:SetScript("OnEvent", ShowSites)
